/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.common;

import java.util.List;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.State;
import net.miowb.workbench.common.PrettyPrinting;

public class TransitionBetweenListsOfStates {
    private List<State> fP1;
    private List<State> fP2;
    private Action fAction;
    private boolean fMust;

    public TransitionBetweenListsOfStates(List<State> p1, List<State> p2, Action act, boolean must) {
        this.fP1 = p1;
        this.fP2 = p2;
        this.fAction = act;
        this.fMust = must;
    }

    public List<State> getFrom() {
        return this.fP1;
    }

    public List<State> getTo() {
        return this.fP2;
    }

    public Action getAction() {
        return this.fAction;
    }

    public boolean isMust() {
        return this.fMust;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransitionBetweenListsOfStates)) {
            return false;
        }
        TransitionBetweenListsOfStates o = (TransitionBetweenListsOfStates)obj;
        if (!this.fAction.getLabel().equals(o.fAction.getLabel())) {
            return false;
        }
        if (this.fMust != o.fMust) {
            return false;
        }
        if (o.fP1.size() != this.fP1.size()) {
            return false;
        }
        for (State s1 : this.fP1) {
            if (o.fP1.contains(s1)) continue;
            return false;
        }
        if (o.fP2.size() != this.fP2.size()) {
            return false;
        }
        for (State s2 : this.fP2) {
            if (o.fP2.contains(s2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.fMust) {
            return "Must " + this.fAction.getLabel() + ": " + PrettyPrinting.ppstates(this.fP1) + " --> " + PrettyPrinting.ppstates(this.fP2);
        }
        return "May " + this.fAction.getLabel() + ": " + PrettyPrinting.ppstates(this.fP1) + " --> " + PrettyPrinting.ppstates(this.fP2);
    }
}

