/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.miowb.common.MioEMFFactory;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.composition.CompositionInternalPairTransition;
import net.miowb.workbench.operations.model.StatePair;

public class PruningHelper {
    public static void removeUnreachableStatesAndTransitions(StatePair startStatePair, List<StatePair> statePairs, List<CompositionInternalPairTransition> transitions) {
        ArrayList<StatePair> toCheck = new ArrayList<StatePair>();
        toCheck.add(startStatePair);
        ArrayList<StatePair> newList = new ArrayList<StatePair>();
        while (!toCheck.isEmpty()) {
            ArrayList<StatePair> newToCheck = new ArrayList<StatePair>();
            for (StatePair statePair : toCheck) {
                if (newList.contains(statePair)) continue;
                newList.add(statePair);
                List<CompositionInternalPairTransition> transitionsStartingFrom = PruningHelper.getTransitionsStartingFrom(statePair, transitions);
                for (CompositionInternalPairTransition pairTransition : transitionsStartingFrom) {
                    newToCheck.add(pairTransition.getTo());
                }
            }
            toCheck = newToCheck;
        }
        statePairs.clear();
        statePairs.addAll(newList);
        Iterator<CompositionInternalPairTransition> i = transitions.iterator();
        while (i.hasNext()) {
            CompositionInternalPairTransition pairTrans = i.next();
            if (statePairs.contains(pairTrans.getFrom()) && statePairs.contains(pairTrans.getTo())) continue;
            i.remove();
        }
    }

    public static List<CompositionInternalPairTransition> getTransitionsStartingFrom(StatePair s, List<CompositionInternalPairTransition> transitions) {
        ArrayList<CompositionInternalPairTransition> transes = new ArrayList<CompositionInternalPairTransition>();
        for (CompositionInternalPairTransition trans : transitions) {
            if (!trans.getFrom().equals(s)) continue;
            transes.add(trans);
        }
        return transes;
    }

    public static void removeUnreachableStatesAndTransitions(ModalIOAutomaton mio) {
        HashSet<State> visited = new HashSet<State>();
        HashSet<State> nextState = new HashSet<State>();
        nextState.add(mio.getStart());
        while (!nextState.isEmpty()) {
            State next = (State)nextState.iterator().next();
            nextState.remove(next);
            visited.add(next);
            for (Transition t : next.getOutgoing()) {
                if (visited.contains(t.getTo())) continue;
                nextState.add(t.getTo());
            }
        }
        mio.getStates().retainAll(visited);
        HashSet<Transition> transitions = new HashSet<Transition>();
        for (Transition t : mio.getTransitions()) {
            if (mio.getStates().contains((Object)t.getFrom()) && mio.getStates().contains((Object)t.getTo())) continue;
            transitions.add(t);
        }
        mio.getMayTransitions().removeAll(transitions);
        mio.getMustTransitions().removeAll(transitions);
    }

    public static void pruneWrtIO(ModalIOAutomaton mio, List<String> problematicStates) {
        List<State> badstates = Helpers.getStatesByLabels(mio, problematicStates);
        mio.getStates().removeAll(badstates);
        boolean universal_reachable = false;
        State universal = null;
        boolean changed = true;
        Transition to_be_removed = null;
        ArrayList<Transition> to_be_added = new ArrayList<Transition>();
        while (changed) {
            changed = false;
            for (Transition t : mio.getTransitions()) {
                if (!mio.getStates().contains((Object)t.getTo()) && !(t.getAction() instanceof InputAction)) {
                    changed = true;
                    to_be_removed = t;
                    mio.getStates().remove((Object)t.getFrom());
                    break;
                }
                if (mio.getStates().contains((Object)t.getTo()) || !(t.getAction() instanceof InputAction)) continue;
                if (!universal_reachable) {
                    universal_reachable = true;
                    universal = MioEMFFactory.createState((ModalIOAutomaton)mio, (String)"uni");
                    for (Action a : mio.getActions()) {
                        MayTransition newTrans = MioEMFFactory.createMayTransition();
                        newTrans.setAction(a);
                        newTrans.setFrom(universal);
                        newTrans.setTo(universal);
                        to_be_added.add((Transition)newTrans);
                    }
                }
                changed = true;
                to_be_removed = t;
                MayTransition newTrans = MioEMFFactory.createMayTransition();
                newTrans.setAction(t.getAction());
                newTrans.setFrom(t.getFrom());
                newTrans.setTo(universal);
                Helpers.addTransitionStandard(to_be_added, (Transition)newTrans);
                break;
            }
            if (!changed || to_be_removed == null) continue;
            if (to_be_removed instanceof MayTransition) {
                mio.getMayTransitions().remove((Object)((MayTransition)to_be_removed));
                continue;
            }
            mio.getMustTransitions().remove((Object)((MustTransition)to_be_removed));
        }
        for (Transition t : to_be_added) {
            if (t instanceof MayTransition) {
                mio.getMayTransitions().add((Object)((MayTransition)t));
            }
            if (!(t instanceof MustTransition)) continue;
            mio.getMustTransitions().add((Object)((MustTransition)t));
        }
    }

    public static void prune(ModalIOAutomaton mio, List<String> problematicStates) {
        ArrayList<State> badstates = new ArrayList<State>();
        for (State p : mio.getStates()) {
            if (!problematicStates.contains(p.getLabel())) continue;
            badstates.add(p);
        }
        mio.getStates().removeAll(badstates);
        boolean changed = true;
        while (changed) {
            changed = false;
            Transition to_be_removed = null;
            for (Transition trans : mio.getTransitions()) {
                if (mio.getStates().contains((Object)trans.getFrom()) && mio.getStates().contains((Object)trans.getTo())) continue;
                changed = true;
                to_be_removed = trans;
                if (!trans.isMust()) break;
                mio.getStates().remove((Object)trans.getFrom());
                break;
            }
            if (!changed) continue;
            if (to_be_removed instanceof MustTransition) {
                mio.getMustTransitions().remove(to_be_removed);
                continue;
            }
            mio.getMayTransitions().remove(to_be_removed);
        }
    }
}

