/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.miowb.common.MioEMFFactory;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.CommunicationAction;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.workbench.operations.model.SingleActionPath;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class PathFinder {
    private State fStart;
    private Action fAction;
    private Set<State> fTargetStates;
    private AllowedTransitions fAllowedTransitions;
    private Map<State, List<SingleActionPath>> fTargetPaths;
    private PassingMode fTauMode;
    private EpsilonMode fEpsilonMode;
    private ModalRefinementImplementation.ActionComparisonType fActionComparisonType;
    private Set<Action> fOtherImportantActions;

    public static PathsFound getPossibleTauEmbeddedTransitions(State state, Action mostImportantAction, Set<Action> otherImportantActions, AllowedTransitions mode, PassingMode tauMode, EpsilonMode epsilonMode, ModalRefinementImplementation.ActionComparisonType actionComparisonType) {
        PathFinder p = new PathFinder(state, mostImportantAction, otherImportantActions, mode, tauMode, epsilonMode, actionComparisonType);
        p.search();
        return new PathsFound(p.getTargetStates(), p.getTargetPaths());
    }

    private PathFinder(State start, Action action, Set<Action> otherImportantActions, AllowedTransitions mode, PassingMode tMode, EpsilonMode eMode, ModalRefinementImplementation.ActionComparisonType actionComparisonType) {
        this.fStart = start;
        this.fAction = action;
        this.fOtherImportantActions = otherImportantActions;
        this.fAllowedTransitions = mode;
        this.fTauMode = tMode;
        this.fEpsilonMode = eMode;
        this.fActionComparisonType = actionComparisonType;
        this.fTargetStates = new LinkedHashSet<State>();
        this.fTargetPaths = new LinkedHashMap<State, List<SingleActionPath>>();
    }

    private void search() {
        if (this.isEpsilonAllowed() && this.canBePassed(this.fAction)) {
            this.fTargetStates.add(this.fStart);
            this.addPath(this.fStart, this.createNewList(MioEMFFactory.createEpsilonTransition((State)this.fStart, (State)this.fStart)));
        }
        this.follow(this.fStart, new LinkedHashMap<State, Mode>(), new ArrayList<Transition>(), Mode.BEFOREACTION);
    }

    private void follow(State state, Map<State, Mode> seen, List<Transition> transitionPath, Mode current) {
        seen.put(state, this.copy(current));
        EList<Transition> outgoing = this.filter((EList<Transition>)state.getOutgoing());
        block4: for (Transition transition : outgoing) {
            State target = transition.getTo();
            List<Transition> currentPath = this.copy(transitionPath);
            currentPath.add(transition);
            switch (current) {
                case BEFOREACTION: {
                    if (this.isSameAction(transition.getAction(), this.fAction)) {
                        this.fTargetStates.add(target);
                        this.addPath(target, currentPath);
                        if (!this.shouldGoOn(seen, target, current) || !this.isTauAllowed() || !this.isTauAfterAllowed()) continue block4;
                        this.follow(target, this.copy(seen), currentPath, Mode.AFTERACTION);
                        break;
                    }
                    if (!this.canBePassed(transition.getAction()) || !this.isTauAllowed() || !this.shouldGoOn(seen, target, current)) continue block4;
                    this.follow(transition.getTo(), this.copy(seen), currentPath, Mode.BEFOREACTION);
                    break;
                }
                case AFTERACTION: {
                    if (!this.canBePassed(transition.getAction())) break;
                    this.fTargetStates.add(target);
                    this.addPath(target, currentPath);
                    if (!this.shouldGoOn(seen, target, current)) break;
                    this.follow(target, this.copy(seen), currentPath, Mode.AFTERACTION);
                }
            }
        }
    }

    private boolean canBePassed(Action action) {
        return action.isInternal() || this.fTauMode == PassingMode.WITH_NON_IMPORTANT_BEFORE && !this.containsAction(this.fOtherImportantActions, action) || this.fTauMode == PassingMode.WITH_TAU_AND_NONSHARED_OUTPUTS_BEFORE && !this.containsAction(this.fOtherImportantActions, action);
    }

    private boolean containsAction(Set<Action> otherImportantActions, Action action) {
        for (Action importantAction : otherImportantActions) {
            if (!this.isSameAction(importantAction, action)) continue;
            return true;
        }
        return false;
    }

    private boolean isTauAfterAllowed() {
        return this.fTauMode == PassingMode.WITH_TAU_BEFORE_AND_AFTER;
    }

    private boolean shouldGoOn(Map<State, Mode> seen, State target, Mode current) {
        Mode mode;
        return !seen.containsKey(target) || !(mode = seen.get(target)).name().equals(current.name());
    }

    private Map<State, List<SingleActionPath>> getTargetPaths() {
        return this.fTargetPaths;
    }

    private List<State> getTargetStates() {
        ArrayList<State> l = new ArrayList<State>();
        l.addAll(this.fTargetStates);
        return l;
    }

    private EList<Transition> filter(EList<Transition> outgoing) {
        if (this.fAllowedTransitions == AllowedTransitions.BOTH) {
            return outgoing;
        }
        BasicEList list = new BasicEList();
        for (Transition transition : outgoing) {
            if (this.fAllowedTransitions == AllowedTransitions.MAYONLY && transition instanceof MayTransition) {
                list.add((Object)transition);
            }
            if (this.fAllowedTransitions != AllowedTransitions.MUSTONLY || !(transition instanceof MustTransition)) continue;
            list.add((Object)transition);
        }
        return list;
    }

    private boolean isSameAction(Action action1, Action action2) {
        if (action1 instanceof InternalAction) {
            return action2 instanceof InternalAction;
        }
        if (!action1.getLabel().equals(action2.getLabel())) {
            return false;
        }
        switch (this.fActionComparisonType) {
            case SAME: {
                if (action1 instanceof InputAction) {
                    return action2 instanceof InputAction;
                }
                if (action1 instanceof OutputAction) {
                    return action2 instanceof OutputAction;
                }
                if (action1 instanceof CommunicationAction) {
                    return action2 instanceof CommunicationAction;
                }
                return false;
            }
            case COMPLEMENTARY: {
                if (action1 instanceof InputAction) {
                    return action2 instanceof OutputAction;
                }
                if (action1 instanceof OutputAction) {
                    return action2 instanceof InputAction;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isSameAction2(Action action1, Action action2) {
        if (action1 instanceof InputAction) {
            return action2 instanceof InputAction && action1.getLabel().equals(action2.getLabel());
        }
        if (action1 instanceof OutputAction) {
            return action2 instanceof OutputAction && action1.getLabel().equals(action2.getLabel());
        }
        if (action1 instanceof InternalAction) {
            return action2 instanceof InternalAction;
        }
        if (action1 instanceof CommunicationAction) {
            return action2 instanceof CommunicationAction && action1.getLabel().equals(action2.getLabel());
        }
        return false;
    }

    private void addPath(State target, List<Transition> pathToTarget) {
        List<SingleActionPath> list = this.fTargetPaths.get(target);
        if (list == null) {
            list = new ArrayList<SingleActionPath>();
            this.fTargetPaths.put(target, list);
        }
        list.add(SingleActionPath.convertAll(pathToTarget));
    }

    private boolean isEpsilonAllowed() {
        return this.fEpsilonMode == EpsilonMode.WITH_EPSILON;
    }

    private boolean isTauAllowed() {
        return this.fTauMode == PassingMode.WITH_TAU_BEFORE || this.fTauMode == PassingMode.WITH_TAU_BEFORE_AND_AFTER || this.fTauMode == PassingMode.WITH_NON_IMPORTANT_BEFORE || this.fTauMode == PassingMode.WITH_TAU_AND_NONSHARED_OUTPUTS_BEFORE;
    }

    private Mode copy(Mode current) {
        return Mode.valueOf(current.name());
    }

    private Map<State, Mode> copy(Map<State, Mode> seen) {
        LinkedHashMap<State, Mode> copy = new LinkedHashMap<State, Mode>();
        for (State key : seen.keySet()) {
            copy.put(key, seen.get(key));
        }
        return copy;
    }

    private List<Transition> copy(List<Transition> transitionPath) {
        ArrayList<Transition> tList = new ArrayList<Transition>();
        tList.addAll(transitionPath);
        return tList;
    }

    private List<Transition> createNewList(MustTransition createEpsilonTransition) {
        ArrayList<Transition> t = new ArrayList<Transition>();
        t.add((Transition)createEpsilonTransition);
        return t;
    }

    public static enum AllowedTransitions {
        MAYONLY,
        MUSTONLY,
        BOTH;

    }

    public static enum EpsilonMode {
        WITH_EPSILON,
        NO_EPISLON;

    }

    private static enum Mode {
        BEFOREACTION,
        AFTERACTION;

    }

    public static enum PassingMode {
        WITH_TAU_BEFORE,
        WITH_TAU_BEFORE_AND_AFTER,
        WITH_NON_IMPORTANT_BEFORE,
        NO_PASSING,
        WITH_TAU_AND_NONSHARED_OUTPUTS_BEFORE;

    }

    public static class PathsFound {
        private List<State> fTargetStates;
        private Map<State, List<SingleActionPath>> fTargetPaths;

        public PathsFound(List<State> targetStates, Map<State, List<SingleActionPath>> targetPaths) {
            this.fTargetStates = targetStates;
            this.fTargetPaths = targetPaths;
        }

        public Map<State, List<SingleActionPath>> getTargetPaths() {
            return this.fTargetPaths;
        }

        public List<State> getTargetStates() {
            return this.fTargetStates;
        }

        public Set<State> getTargetSet() {
            HashSet<State> result = new HashSet<State>();
            for (State s : this.fTargetStates) {
                result.add(s);
            }
            return result;
        }

        public List<SingleActionPath> getPathsTo(State targetState) {
            return this.fTargetPaths.get(targetState);
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("PathsFound ");
            b.append(" size= " + this.getTargetPaths().keySet().size() + " ");
            for (State s : this.fTargetPaths.keySet()) {
                b.append("(" + s.getLabel() + " via " + this.getTargetPaths().get(s).toString() + ") ");
            }
            return b.toString();
        }
    }
}

