/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.CommunicationAction;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.TransitionBetweenListsOfStates;
import net.miowb.operations.common.TransitionBetweenSetsOfStatePairs;
import net.miowb.operations.common.TransitionBetweenStatePairs;
import net.miowb.workbench.operations.model.SetOfStatePairs;
import net.miowb.workbench.operations.model.StateList;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.shell.MessageManager;

public class Helpers {
    public static List<State> getStatesByLabels(ModalIOAutomaton mio, List<String> labels) {
        ArrayList<State> result = new ArrayList<State>();
        for (State s : mio.getStates()) {
            if (!labels.contains(s.getLabel())) continue;
            result.add(s);
        }
        return result;
    }

    public static List<String> convertToStatesAsStrings(List<StatePair> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (StatePair p : list) {
            result.add(p.getLabel());
        }
        return result;
    }

    public static String combineLabelsOfStates(State s1, State s2) {
        return "(" + s1.getLabel() + "," + s2.getLabel() + ")";
    }

    public static void addTransition(ArrayList<TransitionBetweenStatePairs> transitions, TransitionBetweenStatePairs trans) {
        for (TransitionBetweenStatePairs t : transitions) {
            if (!trans.getFrom().equals(t.getFrom()) || !trans.getTo().equals(t.getTo()) || trans.getAction().getLabel() != t.getAction().getLabel()) continue;
            if (trans.isMust()) {
                transitions.remove(t);
                transitions.add(trans);
            }
            return;
        }
        transitions.add(trans);
    }

    public static void addTransitionStandard(List<Transition> transitions, Transition trans) {
        for (Transition t : transitions) {
            if (!trans.getFrom().equals(t.getFrom()) || !trans.getTo().equals(t.getTo()) || trans.getAction().getLabel() != t.getAction().getLabel()) continue;
            if (trans.isMust()) {
                transitions.remove(t);
                transitions.add(trans);
            }
            return;
        }
        transitions.add(trans);
    }

    public static void addSetTransition(List<TransitionBetweenSetsOfStatePairs> transitions, TransitionBetweenSetsOfStatePairs trans) {
        for (TransitionBetweenSetsOfStatePairs t : transitions) {
            if (!trans.getFrom().equals((Object)t.getFrom()) || !trans.getTo().equals((Object)t.getTo()) || trans.getAction().getLabel() != t.getAction().getLabel()) continue;
            if (trans.isMust()) {
                transitions.remove(t);
                transitions.add(trans);
            }
            return;
        }
        transitions.add(trans);
    }

    public static List<StatePair> getProblematicStatePairs(List<StatePair> list) {
        ArrayList<StatePair> result = new ArrayList<StatePair>();
        for (StatePair p : list) {
            if (!p.isProblematic()) continue;
            result.add(p);
        }
        return result;
    }

    public static boolean checkQuotientableAlphabets(ModalIOAutomaton t, ModalIOAutomaton s) {
        List t_in = SignatureHelper.getSetOfLabels((Collection)t.getInputs());
        List t_out = SignatureHelper.getSetOfLabels((Collection)t.getOutputs());
        List t_int = SignatureHelper.getSetOfLabels((Collection)t.getInternals());
        List s_in = SignatureHelper.getSetOfLabels((Collection)s.getInputs());
        List s_out = SignatureHelper.getSetOfLabels((Collection)s.getOutputs());
        List s_int = SignatureHelper.getSetOfLabels((Collection)s.getInternals());
        ArrayList<String> t_in_int = new ArrayList<String>(t_in);
        t_in_int.addAll(t_int);
        ArrayList<String> t_all = new ArrayList<String>(t_in_int);
        t_all.addAll(t_out);
        ArrayList<String> t_out_int = new ArrayList<String>(t_out);
        t_out_int.addAll(t_int);
        return Helpers.isSubsetOfWrt(s_in, t_in_int, t_all) || Helpers.isSubsetOfWrt(s_out, t_out_int, t_all) || Helpers.isSubsetOfWrt(s_int, t_int, t_all);
    }

    private static boolean isSubsetOfWrt(List<String> a, List<String> b, List<String> wrt) {
        for (String s : a) {
            if (b.contains(s) || !wrt.contains(s)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSubsetOf(List<String> a, List<String> b) {
        for (String s : a) {
            if (b.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean sameActionAlphabet(ModalIOAutomaton mio1, ModalIOAutomaton mio2) {
        return Helpers.compareListOfActionsByLabel((List<? extends Action>)mio1.getInputs(), (List<? extends Action>)mio2.getInputs()) || Helpers.compareListOfActionsByLabel((List<? extends Action>)mio1.getOutputs(), (List<? extends Action>)mio2.getOutputs()) || Helpers.compareListOfActionsByLabel((List<? extends Action>)mio1.getInternals(), (List<? extends Action>)mio2.getInternals());
    }

    public static boolean compareListOfActionsByLabel(List<? extends Action> list1, List<? extends Action> list2) {
        boolean found;
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Action action : list1) {
            found = false;
            for (Action action2 : list2) {
                if (!action.getLabel().equals(action2.getLabel())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        for (Action action : list2) {
            found = false;
            for (Action action3 : list1) {
                if (!action3.getLabel().equals(action.getLabel())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean compareListOfLabels(List<String> list1, List<String> list2) {
        boolean found;
        if (list1.size() != list2.size()) {
            return false;
        }
        for (String a1 : list1) {
            found = false;
            for (String a2 : list2) {
                if (!a1.equals(a2)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        for (String a2 : list2) {
            found = false;
            for (String a1 : list1) {
                if (!a1.equals(a2)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static State getStateByLabel(Collection<? extends State> states, String label) {
        for (State state : states) {
            if (!state.getLabel().equals(label)) continue;
            return state;
        }
        return null;
    }

    public static String MioToString(ModalIOAutomaton m) {
        String result = "";
        result = String.valueOf(result) + "Input actions:\n";
        for (InputAction a : m.getInputs()) {
            result = String.valueOf(result) + "  " + a.getLabel() + "\n";
        }
        result = String.valueOf(result) + "Output actions:\n";
        for (InputAction a : m.getOutputs()) {
            result = String.valueOf(result) + "  " + a.getLabel() + "\n";
        }
        result = String.valueOf(result) + "Internal actions:\n";
        for (InputAction a : m.getInternals()) {
            result = String.valueOf(result) + "  " + a.getLabel() + "\n";
        }
        result = String.valueOf(result) + "States:\n";
        for (State s : m.getStates()) {
            result = String.valueOf(result) + "  " + s.getLabel() + "\n";
        }
        result = String.valueOf(result) + "Initial state: " + m.getStart().getLabel() + "\n";
        result = String.valueOf(result) + "May transitions:\n";
        for (MayTransition t : m.getMayTransitions()) {
            result = String.valueOf(result) + "  " + t.getFrom().getLabel() + " - - -> " + t.getTo().getLabel() + " with action " + t.getAction().getLabel() + "\n";
        }
        result = String.valueOf(result) + "Must transitions:\n";
        for (MayTransition t : m.getMustTransitions()) {
            result = String.valueOf(result) + "  " + t.getFrom().getLabel() + " -----> " + t.getTo().getLabel() + " with action " + t.getAction().getLabel() + "\n";
        }
        return result;
    }

    public static String MioToString(ArrayList<StatePair> fVisitedStatePairs, ArrayList<TransitionBetweenStatePairs> fNewTransitions) {
        String result = "";
        for (StatePair sp : fVisitedStatePairs) {
            result = String.valueOf(result) + sp.toString() + " ";
        }
        for (TransitionBetweenStatePairs trans : fNewTransitions) {
            result = String.valueOf(result) + trans.toString() + "\n";
        }
        return result;
    }

    public static void addTransition(List<TransitionBetweenListsOfStates> transitions, TransitionBetweenListsOfStates trans) {
        for (TransitionBetweenListsOfStates t : transitions) {
            if (!Helpers.compare(trans.getFrom(), t.getFrom()) || !Helpers.compare(trans.getTo(), t.getTo()) || trans.getAction().getLabel() != t.getAction().getLabel()) continue;
            if (trans.isMust()) {
                transitions.remove(t);
                transitions.add(trans);
            }
            return;
        }
        transitions.add(trans);
    }

    public static boolean compare(List<?> l1, List<?> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (Object o : l1) {
            if (l2.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static Set<Action> createSharedActions(ModalIOAutomaton t1, ModalIOAutomaton t2) {
        HashSet<Action> sharedActions = new HashSet<Action>();
        sharedActions.addAll(Helpers.copy(Helpers.intersectionBasedOnLabel((List<? extends Action>)t1.getInputs(), (List<? extends Action>)t2.getOutputs())));
        sharedActions.addAll(Helpers.copy(Helpers.intersectionBasedOnLabel((List<? extends Action>)t1.getOutputs(), (List<? extends Action>)t2.getInputs())));
        return sharedActions;
    }

    public static Collection<? extends Action> copy(Collection<? extends Action> oldActions, NewType internal) {
        ArrayList<InputAction> newActions = new ArrayList<InputAction>();
        for (Action action : oldActions) {
            InputAction newAction = null;
            switch (internal) {
                case SAME: {
                    if (action instanceof InputAction) {
                        newAction = MioFactory.eINSTANCE.createInputAction();
                    }
                    if (action instanceof OutputAction) {
                        newAction = MioFactory.eINSTANCE.createOutputAction();
                    }
                    if (action instanceof InternalAction) {
                        newAction = MioFactory.eINSTANCE.createInternalAction();
                    }
                    if (!(action instanceof CommunicationAction)) break;
                    newAction = MioFactory.eINSTANCE.createCommunicationAction();
                    break;
                }
                case IN: {
                    newAction = MioFactory.eINSTANCE.createInputAction();
                    break;
                }
                case OUT: {
                    newAction = MioFactory.eINSTANCE.createOutputAction();
                    break;
                }
                case INTERNAL: {
                    newAction = MioFactory.eINSTANCE.createInternalAction();
                    break;
                }
                case COMM: {
                    newAction = MioFactory.eINSTANCE.createCommunicationAction();
                }
            }
            newAction.setLabel(action.getLabel());
            newActions.add(newAction);
        }
        return newActions;
    }

    public static Collection<? extends Action> copy(Collection<? extends Action> oldActions) {
        return Helpers.copy(oldActions, NewType.SAME);
    }

    public static List<Action> intersectionBasedOnLabel(List<? extends Action> inAndIntOfS1, List<? extends Action> inAndIntOfS2) {
        ArrayList<Action> intersection = new ArrayList<Action>();
        for (Action action : inAndIntOfS1) {
            for (Action action2 : inAndIntOfS2) {
                if (!action.getLabel().equals(action2.getLabel())) continue;
                intersection.add(action);
            }
        }
        return intersection;
    }

    public static Set<Action> withoutBasedOnLabel(List<? extends Action> firstSet, List<? extends Action> secondSet) {
        LinkedHashSet<Action> resultingSet = new LinkedHashSet<Action>();
        for (Action action : firstSet) {
            boolean found = false;
            for (Action action2 : secondSet) {
                if (!action.getLabel().equals(action2.getLabel())) continue;
                found = true;
                break;
            }
            if (found) continue;
            resultingSet.add(action);
        }
        return resultingSet;
    }

    public static Action isInSetBasedOnLabel(Collection<? extends Action> someActionSet, Action someAction) {
        for (Action action : someActionSet) {
            if (!action.getLabel().equals(someAction.getLabel())) continue;
            return action;
        }
        return null;
    }

    public static StatePair findPair(List<StatePair> newStates, State oneState, State anotherState) {
        for (StatePair statePair : newStates) {
            if (statePair.getS1().equals(oneState) && statePair.getS2().equals(anotherState)) {
                return statePair;
            }
            if (!statePair.getS2().equals(oneState) || !statePair.getS1().equals(anotherState)) continue;
            return statePair;
        }
        return null;
    }

    public static StatePair getPair(List<StatePair> newStates, State s1, State s2) {
        for (StatePair statePair : newStates) {
            if (!statePair.getS1().equals(s1) || !statePair.getS2().equals(s2)) continue;
            return statePair;
        }
        return null;
    }

    public static Transition getTransitionForLabel(State state, String label) {
        for (Transition t : state.getOutgoing()) {
            if (!t.getAction().getLabel().equals(label)) continue;
            return t;
        }
        return null;
    }

    public static boolean isDeterministic(ModalIOAutomaton mio) {
        return Helpers.getNextNonDeterministicStateAndAction(mio) != null;
    }

    public static StateAndAction getNextNonDeterministicStateAndAction(ModalIOAutomaton mio) {
        for (State s : mio.getStates()) {
            for (Transition t1 : s.getOutgoing()) {
                for (Transition t2 : s.getOutgoing()) {
                    if (!t1.getAction().getLabel().equals(t2.getAction().getLabel()) || t1.getTo() == t2.getTo()) continue;
                    return new StateAndAction(s, t1.getAction());
                }
            }
        }
        return null;
    }

    public static void prune(List<StatePair> statepairs, List<TransitionBetweenStatePairs> transitions) {
        for (StatePair p : Helpers.getProblematicStatePairs(statepairs)) {
            statepairs.remove(p);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            TransitionBetweenStatePairs to_be_removed = null;
            for (TransitionBetweenStatePairs trans : transitions) {
                if (statepairs.contains(trans.getFrom()) && statepairs.contains(trans.getTo())) continue;
                changed = true;
                to_be_removed = trans;
                if (!trans.isMust()) break;
                statepairs.remove(trans.getFrom());
                break;
            }
            if (!changed) continue;
            transitions.remove(to_be_removed);
            MessageManager.addVerbose((String)("--->PRUNE: removing " + to_be_removed.toString()));
        }
    }

    public static void prune_sets(List<SetOfStatePairs> states, List<TransitionBetweenSetsOfStatePairs> transitions) {
        Object to_be_removed;
        boolean changed = true;
        while (changed) {
            changed = false;
            to_be_removed = null;
            for (SetOfStatePairs p : states) {
                if (!p.isProblematic()) continue;
                changed = true;
                to_be_removed = p;
                break;
            }
            if (!changed) continue;
            states.remove(to_be_removed);
        }
        changed = true;
        while (changed) {
            changed = false;
            to_be_removed = null;
            for (TransitionBetweenSetsOfStatePairs trans : transitions) {
                if (states.contains(trans.getFrom()) && states.contains(trans.getTo())) continue;
                changed = true;
                to_be_removed = trans;
                if (!trans.isMust()) break;
                states.remove(trans.getFrom());
                break;
            }
            if (!changed) continue;
            transitions.remove(to_be_removed);
        }
    }

    public static SetOfStatePairs findSetOfStates(List<SetOfStatePairs> fVisitedSetOfStatePairs, SetOfStatePairs s) {
        for (SetOfStatePairs p : fVisitedSetOfStatePairs) {
            if (!p.equals((Object)s)) continue;
            return p;
        }
        return null;
    }

    public static State getState(ModalIOAutomaton mio, String label) {
        for (State s : mio.getStates()) {
            if (!s.getLabel().equals(label)) continue;
            return s;
        }
        return null;
    }

    public static void removeUniversalState(ModalIOAutomaton mio) {
        State univState = null;
        do {
            univState = null;
            Iterator iterator = mio.getStates().iterator();
            while (iterator.hasNext()) {
                State state;
                univState = state = (State)iterator.next();
                for (Transition incoming : state.getIncoming()) {
                    if (!(incoming instanceof MustTransition)) continue;
                    univState = null;
                    break;
                }
                if (univState == null) continue;
                for (Action a : mio.getActions()) {
                    Transition transForAction = Helpers.getTransitionForLabel(state, a.getLabel());
                    if (transForAction != null && transForAction.getTo() == state) continue;
                    univState = null;
                    break;
                }
                if (univState != null) break;
            }
            if (univState == null) continue;
            mio.getMayTransitions().removeAll((Collection)univState.getOutgoing());
            mio.getMayTransitions().removeAll((Collection)univState.getIncoming());
            mio.getStates().remove((Object)univState);
        } while (univState != null);
    }

    public static Action getAction(ModalIOAutomaton mio, String label) {
        for (Action a : mio.getActions()) {
            if (!a.getLabel().equals(label)) continue;
            return a;
        }
        return null;
    }

    public static StateList getStateList(ArrayList<StateList> stateListList, StateList s) {
        for (StateList l : stateListList) {
            if (!l.matches(s)) continue;
            return l;
        }
        return null;
    }

    public static enum NewType {
        SAME,
        INTERNAL,
        IN,
        OUT,
        COMM;

    }

    public static class StateAndAction {
        private State s;
        private Action a;

        public StateAndAction(State state, Action action) {
            this.s = state;
            this.a = action;
        }

        public State getState() {
            return this.s;
        }

        public Action getAction() {
            return this.a;
        }
    }
}

