/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations;

import java.util.ArrayList;
import java.util.List;
import net.miowb.common.MioHelpers;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.operations.compatibility.RevisedOutputCompatibilityImplementation;
import net.miowb.operations.composition.MioProductOfList;
import net.miowb.operations.conjunction.MioConjunction;
import net.miowb.operations.contracts.common.Normalization;
import net.miowb.operations.contracts.composition.MioContractComposition;
import net.miowb.operations.contracts.refinement.MioContractRefinement;
import net.miowb.operations.disjunction.MioDisjunction;
import net.miowb.operations.environmentcorrectness.EnvironmentCorrectnessImplementation;
import net.miowb.operations.maxenvop.MioMaximalEnvironmentOperation;
import net.miowb.operations.mts.quotient.MTSQuotient;
import net.miowb.operations.quotient.MioQuotient;
import net.miowb.operations.refinement.MioStrongRefinement;
import net.miowb.operations.refinement.MioWeakRefinement;
import net.miowb.operations.signature.MioStrongExtension;
import net.miowb.operations.signature.MioWeakExtension;
import net.miowb.operations.signature.SignatureExtension;
import net.miowb.operations.strengthening.MioStrengthen;
import net.miowb.operations.utilities.MioReachablePart;
import net.miowb.operations.utilities.MioStrongMinimization;
import net.miowb.operations.utilities.MioWeakMinimization;
import net.miowb.operations.weakening.MioWeakening;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.IMioOperations;
import net.miowb.workbench.operations.result.CompatibilityResult;
import net.miowb.workbench.operations.result.ConjunctionResult;
import net.miowb.workbench.operations.result.DisjunctionResult;
import net.miowb.workbench.operations.result.QuotientResult;
import net.miowb.workbench.operations.result.RefinementResult;

public class MioOperations
implements IMioOperations {
    public void checkStrongOutputCompatibility(List<ModalIOAutomaton> mios) throws MioException {
        new RevisedOutputCompatibilityImplementation(mios, CompatibilityResult.CompatibilityType.STRONG).execute();
    }

    public void checkWeakOutputCompatibility(List<ModalIOAutomaton> mios) throws MioException {
        new RevisedOutputCompatibilityImplementation(mios, CompatibilityResult.CompatibilityType.WEAK).execute();
    }

    public RefinementResult checkStrongModalRefinement(ModalIOAutomaton concreteMio, ModalIOAutomaton abstractMio, boolean weakAlphabetExtension, boolean printToConsole) {
        return new MioStrongRefinement().checkRefinement(concreteMio, abstractMio, weakAlphabetExtension, printToConsole);
    }

    public RefinementResult checkWeakModalRefinement(ModalIOAutomaton concreteMio, ModalIOAutomaton abstractMio, boolean weakAlphabetExtension, boolean printToConsole) {
        return new MioWeakRefinement().checkRefinement(concreteMio, abstractMio, weakAlphabetExtension, printToConsole);
    }

    public ModalIOAutomaton compose(List<ModalIOAutomaton> mios) throws MioException {
        return new MioProductOfList().syncProduct(mios).getAutomaton();
    }

    public ModalIOAutomaton conjoin(ModalIOAutomaton left, ModalIOAutomaton right) throws MioException {
        ConjunctionResult result = new MioConjunction().conjoin(left, right);
        return result.getAutomaton();
    }

    public ModalIOAutomaton disjoin(ModalIOAutomaton left, ModalIOAutomaton right) throws MioException {
        DisjunctionResult result = new MioDisjunction().disjoin(left, right);
        return result.getAutomaton();
    }

    public ModalIOAutomaton quotient(ModalIOAutomaton large, ModalIOAutomaton small) throws MioException {
        QuotientResult result = new MioQuotient().divide(large, small);
        return result.getAutomaton();
    }

    public ModalIOAutomaton quotientMTS(ModalIOAutomaton large, ModalIOAutomaton small) throws MioException {
        QuotientResult result = new MTSQuotient().divide(large, small);
        return result.getAutomaton();
    }

    public ModalIOAutomaton composeMTS(List<ModalIOAutomaton> mios) throws MioException {
        throw new MioException("Not implemented yet");
    }

    public ModalIOAutomaton composeOptimistic_WRT_StrongOutputCompatibility(List<ModalIOAutomaton> mios) throws MioException {
        throw new MioException("Not implemented yet");
    }

    public ModalIOAutomaton weaken(ModalIOAutomaton assume, ModalIOAutomaton guarantee) throws MioException {
        return new MioWeakening().weaken(assume, guarantee).getAutomaton();
    }

    public ModalIOAutomaton strengthen(ModalIOAutomaton assume, ModalIOAutomaton guarantee) throws MioException {
        return new MioStrengthen().strengthen(assume, guarantee).getAutomaton();
    }

    public void checkStrongModalContractRefinement(ModalIOContract cright, ModalIOContract cleft) throws MioException {
        new MioContractRefinement().checkRefinement(cright, cleft);
    }

    public ModalIOContract disjoin(ModalIOContract cright, ModalIOContract cleft) throws MioException {
        throw new MioException("Not implemented yet");
    }

    public ModalIOContract conjoin(ModalIOContract cright, ModalIOContract cleft) throws MioException {
        throw new MioException("Not implemented yet");
    }

    public ModalIOContract compose(ModalIOContract cleft, ModalIOContract cright) throws MioException {
        return new MioContractComposition().combine(cleft, cright).getContract();
    }

    public void stronglyExtend(ModalIOAutomaton mio, List<Action> actions) {
        SignatureExtension.extendSignature(mio, actions, SignatureExtension.SignatureExtensionType.STRONG);
    }

    public void weaklyExtend(ModalIOAutomaton mio, List<Action> actions) {
        SignatureExtension.extendSignature(mio, actions, SignatureExtension.SignatureExtensionType.WEAK);
    }

    public boolean isDeterministic(ModalIOAutomaton mio) throws MioException {
        throw new MioException("Not implemented yet");
    }

    public void deleteUnreachableParts(ModalIOAutomaton mio) {
        new MioReachablePart().execute(mio);
    }

    public void stronglyExtend(ModalIOAutomaton mio, Action a) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(a);
        new MioStrongExtension().extend(mio, actions);
    }

    public void weaklyExtend(ModalIOAutomaton mio, Action a) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(a);
        new MioWeakExtension().extend(mio, actions);
    }

    public ModalIOAutomaton stronglyExtendToNewMIO(ModalIOAutomaton mio, Action a) {
        ModalIOAutomaton copy = MioHelpers.copy((ModalIOAutomaton)mio);
        this.stronglyExtend(copy, a);
        return copy;
    }

    public ModalIOAutomaton weaklyExtendToNewMIO(ModalIOAutomaton mio, Action a) {
        ModalIOAutomaton copy = MioHelpers.copy((ModalIOAutomaton)mio);
        this.weaklyExtend(copy, a);
        return copy;
    }

    public void stronglyMinimize(ModalIOAutomaton mio) {
        new MioStrongMinimization().execute(mio);
    }

    public void weaklyMinimize(ModalIOAutomaton mio) {
        new MioWeakMinimization().execute(mio);
    }

    public ModalIOAutomaton stronglyMinimizeToNewMIO(ModalIOAutomaton mio) {
        ModalIOAutomaton copy = MioHelpers.copy((ModalIOAutomaton)mio);
        this.stronglyMinimize(copy);
        return copy;
    }

    public ModalIOAutomaton weaklyMinimizeToNewMIO(ModalIOAutomaton mio) {
        ModalIOAutomaton copy = MioHelpers.copy((ModalIOAutomaton)mio);
        this.weaklyMinimize(copy);
        return copy;
    }

    public ModalIOAutomaton computeMaxStrongCorrectEnvironment(ModalIOAutomaton spec, ModalIOAutomaton env) throws MioException {
        MioMaximalEnvironmentOperation op = new MioMaximalEnvironmentOperation();
        return op.computeMaximalStrongEnvironment(spec, env);
    }

    public ModalIOContract normalize(ModalIOContract contract) throws MioException {
        return Normalization.normalize(contract);
    }

    public CompatibilityResult checkStrongEnvironmentCorrectness(ModalIOAutomaton specification, ModalIOAutomaton environment) throws MioException {
        EnvironmentCorrectnessImplementation check = new EnvironmentCorrectnessImplementation(CompatibilityResult.CompatibilityType.STRONG, specification, environment);
        return check.checkEnvironmentCorrectness();
    }

    public CompatibilityResult checkWeakEnvironmentCorrectness(ModalIOAutomaton specification, ModalIOAutomaton environment) throws MioException {
        EnvironmentCorrectnessImplementation check = new EnvironmentCorrectnessImplementation(CompatibilityResult.CompatibilityType.WEAK, specification, environment);
        return check.checkEnvironmentCorrectness();
    }
}

