/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.view.commands;

import java.io.IOException;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.diagram.part.Messages;
import net.miowb.model.mio.diagram.part.ModalioDiagramEditorPlugin;
import net.miowb.model.mio.diagram.part.ModalioDiagramEditorUtil;
import net.miowb.model.mio.diagram.part.ModalioVisualIDRegistry;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;

public class InitMioDiagramCommand
extends AbstractTransactionalCommand {
    private final TransactionalEditingDomain domain;
    private final URI mioURI;
    private final URI mioDiagramURI;

    public InitMioDiagramCommand(TransactionalEditingDomain domain, IFile mioFile, IFile mioDiagramFile) {
        super(domain, "creatediagramcommand", null);
        this.domain = domain;
        this.mioURI = URI.createPlatformResourceURI((String)mioFile.getFullPath().toString(), (boolean)true);
        this.mioDiagramURI = URI.createPlatformResourceURI((String)mioDiagramFile.getFullPath().toString(), (boolean)true);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ResourceSet resourceSet = this.domain.getResourceSet();
        Resource inputResource = resourceSet.getResource(this.mioURI, true);
        Resource outputResource = resourceSet.createResource(this.mioDiagramURI);
        EList contents = inputResource.getContents();
        ModalIOAutomaton inputModel = null;
        for (EObject eObject : contents) {
            if (!(eObject instanceof ModalIOAutomaton)) continue;
            inputModel = (ModalIOAutomaton)eObject;
            break;
        }
        if (!(inputModel instanceof ModalIOAutomaton)) {
            return CommandResult.newErrorCommandResult((String)"Contents could be read; but was expecting a ModalIOAutomaton in there.");
        }
        int diagramVID = ModalioVisualIDRegistry.getDiagramVisualID(inputModel);
        if (diagramVID != 1000) {
            return CommandResult.newErrorCommandResult((String)Messages.ModalioNewDiagramFileWizard_IncorrectRootError);
        }
        Diagram diagram = ViewService.createDiagram((EObject)inputModel, (String)"Modalio", (PreferencesHint)ModalioDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        outputResource.getContents().add((Object)diagram);
        try {
            outputResource.save(ModalioDiagramEditorUtil.getSaveOptions());
        }
        catch (IOException ex) {
            ModalioDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + this.mioDiagramURI, (Throwable)ex);
        }
        return CommandResult.newOKCommandResult();
    }
}

