/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.view;

import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.views.view.ActionListener;
import net.miowb.views.view.DropHelper;
import net.miowb.views.view.FileSelectionComposite;
import net.miowb.views.view.Side;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ResourceTransfer;

public class SelectionPanel
extends Composite {
    private List<ActionListener> fListeners = new ArrayList<ActionListener>();
    private FileSelectionComposite fFileSelectionCombo;
    private Side fSide;
    private Composite fButtons;

    public SelectionPanel(Composite parent, Side left) {
        super(parent, 2048);
        this.fSide = left;
        this.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 4).applyTo((Control)this);
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo((Composite)this);
        Label l = new Label((Composite)this, 0);
        l.setText(left == Side.LEFT ? "Concrete Specification" : "Abstract Specification");
        l.setBackground(this.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 4).applyTo((Control)l);
        this.fButtons = new Composite((Composite)this, 0);
        this.fButtons.setBackground(this.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 4).applyTo((Control)this.fButtons);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.fButtons);
        final ToolBar bar = new ToolBar(this.fButtons, 64);
        GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)bar);
        bar.setBackground(this.getDisplay().getSystemColor(1));
        bar.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = bar.getClientArea();
                Point size = bar.computeSize(rect.width, -1);
                bar.setSize(size);
            }
        });
        this.createNormalToolbarButton(bar, "Layout", new Runnable(){

            @Override
            public void run() {
                for (ActionListener l : SelectionPanel.this.fListeners) {
                    l.relayout(SelectionPanel.this.fSide);
                }
            }
        });
        this.createNormalToolbarButton(bar, "Clear", new Runnable(){

            @Override
            public void run() {
                for (ActionListener l : SelectionPanel.this.fListeners) {
                    l.clear(SelectionPanel.this.fSide);
                }
            }
        });
        this.createNormalToolbarButton(bar, "Save", new Runnable(){

            @Override
            public void run() {
                for (ActionListener l : SelectionPanel.this.fListeners) {
                    l.save(SelectionPanel.this.fSide);
                }
            }
        });
        this.fFileSelectionCombo = new FileSelectionComposite(this, left);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 128).applyTo((Control)this.fFileSelectionCombo);
        DropTarget t = new DropTarget((Control)this, 7);
        t.setTransfer(new Transfer[]{ResourceTransfer.getInstance()});
        t.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent event) {
                DropHelper.changeDropOperationToCopy(event);
            }

            public void drop(DropTargetEvent event) {
                IFile file = DropHelper.getFileFromDrop(event);
                if (file == null) {
                    event.detail = 0;
                } else {
                    SelectionPanel.this.fileReceived(file);
                }
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragEnter(DropTargetEvent event) {
                DropHelper.changeDropOperationToCopy(event);
            }
        });
    }

    private void createNormalToolbarButton(ToolBar bar, String name, final Runnable runnable) {
        ToolItem toolBarItem = new ToolItem(bar, 8);
        toolBarItem.setText(name);
        toolBarItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                runnable.run();
            }
        });
    }

    public void addActionListener(ActionListener listener) {
        this.fListeners.add(listener);
        this.fFileSelectionCombo.addActionListener(listener);
    }

    public void setSelection(ModalIOAutomaton tom) {
        this.fFileSelectionCombo.setSelection(tom);
    }

    protected void fileReceived(IFile first) {
        for (ActionListener l : this.fListeners) {
            l.fileOpened(this.fSide, first);
        }
    }

    private void createDDToolbarButton(final ToolBar toolBar, String name) {
        final Menu menu = new Menu((Decorations)toolBar.getShell(), 8);
        final ToolItem toolBarItem = new ToolItem(toolBar, 4);
        toolBarItem.setText(name);
        toolBarItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = toolBarItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        this.addItem(toolBar, menu, toolBarItem, "Hide (Same Signature)", true);
        this.addItem(toolBar, menu, toolBarItem, "Hide (Complementary Signature)", false);
    }

    private void addItem(ToolBar toolBar, Menu menu, ToolItem previousToolItem, String title, final boolean same) {
        MenuItem innerItem = new MenuItem(menu, 8);
        innerItem.setText(title);
        innerItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ActionListener l : SelectionPanel.this.fListeners) {
                    l.hide(SelectionPanel.this.fSide, same);
                }
            }
        });
    }
}

