/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.model.mio.diagram.edit.parts.ModalIOAutomatonEditPart;
import net.miowb.model.mio.diagram.edit.parts.StateEditPart;
import net.miowb.model.mio.diagram.edit.parts.TransitionEditPart;
import net.miowb.model.mio.diagram.edit.view.DiagramNodeWrapper;
import net.miowb.views.view.Side;
import net.miowb.views.view.commands.CreateContainerDiagramCommand;
import net.miowb.views.view.commands.InsertTransitionViewCommand;
import net.miowb.views.view.commands.LayoutDiagramCommand;
import net.miowb.views.view.commands.MoveDiagramCommand;
import net.miowb.views.view.commands.RemoveDiagramCommand;
import net.miowb.views.view.commands.RemoveTransitionViewCommand;
import net.miowb.views.view.commands.WrapDiagramCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.widgets.Control;

public class ModalioOperationsViewer
extends DiagramGraphicalViewer {
    private final int VIEWER_BORDER_PADDING = 20;
    private Map<Side, DiagramNodeWrapper> fInputMap;
    private Map<Side, ModalIOAutomatonEditPart> fMioPartMap;
    private Map<Side, Map<EObject, IGraphicalEditPart>> fEditPartMap;
    private final TransactionalEditingDomain domain;
    private Set<Connector> refinementLinks;
    private Set<EditPart> markedEditParts;
    private Diagram rootDiagram;

    public ModalioOperationsViewer(TransactionalEditingDomain domain) {
        this.domain = domain;
        this.fInputMap = new LinkedHashMap<Side, DiagramNodeWrapper>();
        this.fMioPartMap = new LinkedHashMap<Side, ModalIOAutomatonEditPart>();
        this.fEditPartMap = new LinkedHashMap<Side, Map<EObject, IGraphicalEditPart>>();
        this.refinementLinks = new LinkedHashSet<Connector>();
        this.markedEditParts = new LinkedHashSet<EditPart>();
        DiagramEditDomain ded = new DiagramEditDomain(null);
        CommandStack stack = ded.getCommandStack();
        if (stack != null) {
            stack.dispose();
        }
        DiagramCommandStack diagramStack = new DiagramCommandStack((IDiagramEditDomain)ded);
        ded.setCommandStack((CommandStack)diagramStack);
        CreateContainerDiagramCommand ccdc = new CreateContainerDiagramCommand(domain);
        diagramStack.execute((Command)new ICommandProxy((ICommand)ccdc));
        this.rootDiagram = ccdc.getDiagram();
        RootEditPart rootEP = EditPartService.getInstance().createRootEditPart(this.rootDiagram);
        PreferencesHint hint = new PreferencesHint("ModalioCompareView");
        PreferenceStore store = new PreferenceStore();
        this.hookWorkspacePreferenceStore((IPreferenceStore)store);
        store.setValue("Global.enableAntiAlias", true);
        PreferencesHint.registerPreferenceStore((PreferencesHint)hint, (Object)store);
        if (rootEP instanceof IDiagramPreferenceSupport) {
            ((IDiagramPreferenceSupport)rootEP).setPreferencesHint(hint);
        }
        this.setRootEditPart(rootEP);
        this.setEditDomain((EditDomain)ded);
        this.setEditPartFactory((EditPartFactory)EditPartService.getInstance());
        this.setContents(this.rootDiagram);
    }

    public void setControl(Control control) {
        super.setControl(control);
    }

    private IFigure getRFigure() {
        return ((DiagramRootEditPart)this.getRootEditPart()).getFigure();
    }

    private DiagramCommandStack getCommandStack() {
        return (DiagramCommandStack)this.getEditDomain().getCommandStack();
    }

    public void setInput(Side side, DiagramImpl diagram) {
        this.clearMarkersAndRefinement();
        DiagramNodeWrapper oldWrapper = this.fInputMap.get((Object)side);
        if (oldWrapper != null) {
            this.getCommandStack().execute((Command)new ICommandProxy((ICommand)new RemoveDiagramCommand(this.domain, this.rootDiagram, oldWrapper)));
            this.fMioPartMap.remove((Object)side);
        }
        if (diagram == null) {
            return;
        }
        boolean needLayout = false;
        if (diagram.getChildren().size() == 0) {
            needLayout = true;
        }
        DiagramNodeWrapper wrapper = new DiagramNodeWrapper(diagram);
        this.fInputMap.put(side, wrapper);
        this.getCommandStack().execute((Command)new ICommandProxy((ICommand)new WrapDiagramCommand(this.domain, (View)this.rootDiagram, (View)wrapper)));
        ModalIOAutomatonEditPart part = this.searchRootChildren(wrapper);
        this.fMioPartMap.put(side, part);
        this.fEditPartMap.put(side, this.generateEditPartMap((IGraphicalEditPart)part));
        if (needLayout) {
            this.applyLayout(side);
        }
        this.positionDiagrams();
    }

    private ModalIOAutomatonEditPart searchRootChildren(DiagramNodeWrapper wrapper) {
        EditPart rep = this.getRootEditPart().getContents();
        for (Object o : rep.getChildren()) {
            DiagramNodeWrapper dnw;
            ModalIOAutomatonEditPart mioep;
            if (!(o instanceof ModalIOAutomatonEditPart) || !((mioep = (ModalIOAutomatonEditPart)o).getModel() instanceof DiagramNodeWrapper) || !(dnw = (DiagramNodeWrapper)mioep.getModel()).equals(wrapper)) continue;
            return mioep;
        }
        return null;
    }

    private void positionDiagrams() {
        ModalIOAutomatonEditPart leftPart = this.fMioPartMap.get((Object)Side.LEFT);
        ModalIOAutomatonEditPart rightPart = this.fMioPartMap.get((Object)Side.RIGHT);
        Rectangle leftRect = this.getChildArea((IGraphicalEditPart)leftPart);
        Rectangle rightRect = this.getChildArea((IGraphicalEditPart)rightPart);
        Rectangle visibleRect = ((GraphicalEditPart)this.getRootEditPart()).getFigure().getClientArea();
        if (leftPart != null) {
            this.getCommandStack().execute((Command)new ICommandProxy((ICommand)new MoveDiagramCommand(this.domain, leftPart, new Point(20 - leftRect.x, 20 - leftRect.y))));
        }
        if (rightPart != null) {
            Point newOriginMovement = new Point();
            if (leftRect.width + rightRect.width + 40 < visibleRect.width) {
                newOriginMovement.x = visibleRect.width - rightRect.width - rightRect.x - 20 - 20;
                newOriginMovement.y = 20 - rightRect.y;
            } else {
                newOriginMovement.x = 40 + leftRect.width - rightRect.x;
                newOriginMovement.y = 20 - rightRect.y;
            }
            this.getCommandStack().execute((Command)new ICommandProxy((ICommand)new MoveDiagramCommand(this.domain, rightPart, newOriginMovement)));
        }
    }

    private Rectangle getChildArea(IGraphicalEditPart part) {
        if (part == null) {
            return new Rectangle();
        }
        ((GraphicalEditPart)this.getRootEditPart()).getFigure().validate();
        Rectangle diagramRec = null;
        List list = part.getChildren();
        LinkedList partList = new LinkedList();
        partList.addAll(list);
        for (Object o : list) {
            IGraphicalEditPart gep = (IGraphicalEditPart)o;
            for (IGraphicalEditPart connPart : gep.getSourceConnections()) {
                partList.addAll(connPart.getChildren());
            }
        }
        if (Collections.EMPTY_LIST == list) {
            return new Rectangle();
        }
        for (IGraphicalEditPart childPart : partList) {
            Rectangle r = null;
            r = childPart.getFigure().getBounds();
            if (diagramRec == null) {
                diagramRec = r;
            }
            diagramRec = diagramRec.getUnion(r);
        }
        if (diagramRec == null) {
            diagramRec = new Rectangle();
        }
        return diagramRec;
    }

    private Map<EObject, IGraphicalEditPart> generateEditPartMap(IGraphicalEditPart gep) {
        HashMap<EObject, IGraphicalEditPart> map = new HashMap<EObject, IGraphicalEditPart>();
        this.addChildren(map, gep);
        return map;
    }

    private void addChildren(Map<EObject, IGraphicalEditPart> map, IGraphicalEditPart gep) {
        IGraphicalEditPart child;
        for (Object o : gep.getChildren()) {
            child = (IGraphicalEditPart)o;
            if (child instanceof StateEditPart || child instanceof TransitionEditPart) {
                map.put(child.resolveSemanticElement(), child);
            }
            this.addChildren(map, child);
        }
        for (Object o : gep.getSourceConnections()) {
            child = (IGraphicalEditPart)o;
            if (!(child instanceof TransitionEditPart)) continue;
            map.put(child.resolveSemanticElement(), child);
        }
    }

    public boolean hasTwoGraphs() {
        return this.fMioPartMap.get((Object)Side.LEFT) != null && this.fMioPartMap.get((Object)Side.RIGHT) != null;
    }

    public ModalIOAutomaton getAutomaton(Side side) {
        ModalIOAutomatonEditPart mioPart = this.fMioPartMap.get((Object)side);
        return mioPart != null ? (ModalIOAutomaton)mioPart.resolveSemanticElement() : null;
    }

    private StateEditPart getStateEditPartFor(Side side, State state) {
        StateEditPart sep = null;
        Map<EObject, IGraphicalEditPart> map = this.fEditPartMap.get((Object)side);
        if (map != null) {
            sep = (StateEditPart)map.get(state);
        }
        return sep;
    }

    private TransitionEditPart getTransitionEditPartFor(Side side, Transition transition) {
        TransitionEditPart tep = null;
        Map<EObject, IGraphicalEditPart> map = this.fEditPartMap.get((Object)side);
        if (map != null) {
            tep = (TransitionEditPart)map.get(transition);
        }
        return tep;
    }

    public void markProblematic(State state) {
        StateEditPart sep = this.getStateEditPartFor(Side.LEFT, state);
        if (sep == null) {
            sep = this.getStateEditPartFor(Side.RIGHT, state);
        }
        if (sep != null) {
            sep.setMarkedProblematic(true);
            this.markedEditParts.add((EditPart)sep);
        }
    }

    public void markProblematic(Transition transition) {
        TransitionEditPart tep = this.getTransitionEditPartFor(Side.LEFT, transition);
        if (tep == null) {
            tep = this.getTransitionEditPartFor(Side.RIGHT, transition);
        }
        if (tep != null) {
            tep.setMarkedProblematic(true);
            this.markedEditParts.add((EditPart)tep);
        }
    }

    public void setMarked(Transition transition, boolean mark) {
        TransitionEditPart tep = this.getTransitionEditPartFor(Side.LEFT, transition);
        if (tep == null) {
            tep = this.getTransitionEditPartFor(Side.RIGHT, transition);
        }
        if (tep != null) {
            tep.setMarked(mark);
            this.markedEditParts.add((EditPart)tep);
        }
    }

    public void mark(Transition transition) {
        this.setMarked(transition, true);
    }

    public void reset(Transition transition) {
        this.setMarked(transition, false);
    }

    public void addRefinementLink(State leftHandSide, State rightHandSide) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        View left = this.getStateEditPartFor(Side.LEFT, leftHandSide).getNotationView();
        View right = this.getStateEditPartFor(Side.RIGHT, rightHandSide).getNotationView();
        this.getCommandStack().execute((Command)new ICommandProxy((ICommand)new InsertTransitionViewCommand(this.domain, this.rootDiagram, edge, left, right)));
        this.refinementLinks.add(edge);
    }

    public void clearMarkersAndRefinement() {
        this.getCommandStack().execute((Command)new ICommandProxy((ICommand)new RemoveTransitionViewCommand(this.domain, this.rootDiagram, this.refinementLinks)));
        this.refinementLinks.clear();
        for (EditPart ep : this.markedEditParts) {
            if (ep instanceof TransitionEditPart) {
                TransitionEditPart tep = (TransitionEditPart)ep;
                tep.setMarked(false);
                tep.setMarkedProblematic(false);
                continue;
            }
            if (!(ep instanceof StateEditPart)) continue;
            StateEditPart sep = (StateEditPart)ep;
            sep.setMarkedProblematic(false);
        }
        this.markedEditParts.clear();
    }

    public void applyLayout(Side side) {
        ModalIOAutomatonEditPart mioPart = this.fMioPartMap.get((Object)side);
        ModalIOAutomaton mio = this.getAutomaton(side);
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart startPart = null;
        HashMap<org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart, Node> partNodeMap = new HashMap<org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart, Node>();
        HashSet<ConnectionEditPart> relationshipsToConsider = new HashSet<ConnectionEditPart>();
        for (Object o : mioPart.getChildren()) {
            org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart gep = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)o;
            if (!(gep instanceof StateEditPart)) continue;
            partNodeMap.put(gep, (Node)gep.getNotationView());
            if (gep.resolveSemanticElement().equals(mio.getStart())) {
                startPart = gep;
            }
            for (Object con : gep.getSourceConnections()) {
                ConnectionEditPart cep = (ConnectionEditPart)con;
                if (!(cep instanceof TransitionEditPart)) continue;
                relationshipsToConsider.add(cep);
            }
        }
        if (startPart == null) {
            startPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)mioPart.getChildren().get(0);
        }
        this.getCommandStack().execute((Command)new ICommandProxy((ICommand)new LayoutDiagramCommand(this.domain, startPart, partNodeMap, relationshipsToConsider)));
        this.positionDiagrams();
    }

    public Diagram getDiagram(Side side) {
        DiagramNodeWrapper diagramNodeWrapper = this.fInputMap.get((Object)side);
        if (diagramNodeWrapper == null) {
            return null;
        }
        return diagramNodeWrapper.getDiagram();
    }
}

