/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.view;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.miowb.common.FileSaveDialog;
import net.miowb.common.MioEMFHelper;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.model.mio.diagram.edit.parts.TransitionEditPart;
import net.miowb.model.mio.diagram.part.ModalioDiagramEditorPlugin;
import net.miowb.views.MioDiagramCustomPlugin;
import net.miowb.views.view.ActionListener;
import net.miowb.views.view.DiagramLoader;
import net.miowb.views.view.DropHelper;
import net.miowb.views.view.MiddlePanel;
import net.miowb.views.view.ModalioOperationsViewer;
import net.miowb.views.view.SelectionPanel;
import net.miowb.views.view.Side;
import net.miowb.views.view.commands.AutomatonUtilsHideCommand;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.IMioBinaryCompatibilityOperation;
import net.miowb.workbench.operations.IMioOperation;
import net.miowb.workbench.operations.IMioRefinementOperation;
import net.miowb.workbench.operations.model.RefinementRelation;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.CompatibilityResult;
import net.miowb.workbench.operations.result.RefinementResult;
import net.miowb.workbench.shell.MessageManager;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class ModalioOperationView
extends ViewPart
implements ActionListener,
ISelectionChangedListener {
    public static final String ID = "net.miowb.views.view.ModalioOperationView";
    private static final String PATH_SELECTION_DEFAULT_TEXT = "Click to select path...";
    private static final String LABEL_DEFAULT_TEXT = "Select an operation...";
    private Composite fStatusComposite;
    private SelectionPanel fLeftSelectionPanel;
    private SelectionPanel fRightSelectionPanel;
    private MiddlePanel fMiddlePanel;
    private Label fLabel;
    private CCombo fCombo;
    private List<RefinementRelation> fProblemPaths;
    private RefinementRelation fRefinementRelation;
    private TransactionalEditingDomain editingDomain;
    private ModalioOperationsViewer diagramViewer;
    Set<Transition> lastHighlightedPath = new LinkedHashSet<Transition>();
    private List<ActionListener> fListeners = new ArrayList<ActionListener>();

    public void createPartControl(Composite parent) {
        Composite inner = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(inner);
        Composite upper = new Composite(inner, 2048);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).applyTo((Control)upper);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(5, 5).spacing(10, 2).applyTo(upper);
        upper.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.fLeftSelectionPanel = new SelectionPanel(upper, Side.LEFT);
        this.fLeftSelectionPanel.addActionListener(this);
        this.fMiddlePanel = new MiddlePanel(upper);
        this.fMiddlePanel.addActionListener(this);
        this.fRightSelectionPanel = new SelectionPanel(upper, Side.RIGHT);
        this.fRightSelectionPanel.addActionListener(this);
        this.fStatusComposite = new Composite(inner, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).hint(-1, 40).grab(true, false).applyTo((Control)this.fStatusComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(8, 2).applyTo(this.fStatusComposite);
        this.fLabel = new Label(this.fStatusComposite, 4);
        this.fLabel.setText(LABEL_DEFAULT_TEXT);
        this.setGray();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fLabel);
        this.fCombo = new CCombo(this.fStatusComposite, 2060);
        GridDataFactory.fillDefaults().hint(200, -1).applyTo((Control)this.fCombo);
        this.fCombo.setText(PATH_SELECTION_DEFAULT_TEXT);
        this.fCombo.setEnabled(false);
        this.fCombo.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.fCombo.setCursor(this.getShell().getDisplay().getSystemCursor(0));
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ModalioOperationView.this.fCombo.getSelectionIndex();
                if (ModalioOperationView.this.fProblemPaths != null) {
                    RefinementRelation problemPath = (RefinementRelation)ModalioOperationView.this.fProblemPaths.get(selectionIndex);
                    for (ActionListener l : ModalioOperationView.this.fListeners) {
                        l.problemPathSelected(problemPath);
                    }
                    ModalioOperationView.this.problemPathSelected(problemPath);
                }
            }
        });
        this.diagramViewer = new ModalioOperationsViewer(this.getEditingDomain());
        Control diagramControl = this.diagramViewer.createControl(inner);
        this.diagramViewer.addSelectionChangedListener(this);
        diagramControl.setBackground(ColorConstants.listBackground);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(diagramControl);
        DropTarget t = new DropTarget(diagramControl, 7);
        t.setTransfer(new Transfer[]{ResourceTransfer.getInstance()});
        t.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent event) {
                DropHelper.changeDropOperationToCopy(event);
            }

            public void drop(DropTargetEvent event) {
                Point localPoint = ModalioOperationView.this.diagramViewer.getControl().toControl(new Point(event.x, event.y));
                IFile file = DropHelper.getFileFromDrop(event);
                if (file == null) {
                    event.detail = 0;
                } else {
                    ModalioOperationView.this.fileReceived(localPoint.x, localPoint.y, file);
                }
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragEnter(DropTargetEvent event) {
                DropHelper.changeDropOperationToCopy(event);
            }
        });
    }

    public void reset() {
        this.fCombo.setEnabled(false);
        this.fCombo.removeAll();
        this.fCombo.setText(PATH_SELECTION_DEFAULT_TEXT);
        this.fProblemPaths = null;
        this.setGray();
        this.fLabel.setText(LABEL_DEFAULT_TEXT);
        this.diagramViewer.clearMarkersAndRefinement();
    }

    public void setProblemPaths(List<RefinementRelation> problemPaths) {
        if (problemPaths.size() > 0) {
            this.fCombo.setEnabled(true);
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < problemPaths.size()) {
                names.add("Problem Path " + (i + 1));
                ++i;
            }
            this.fCombo.setItems(names.toArray(new String[0]));
            this.fProblemPaths = problemPaths;
            this.fCombo.select(0);
            this.problemPathSelected(this.fProblemPaths.get(0));
        }
    }

    protected void fileReceived(int x, int y, IFile file) {
        int middle = this.diagramViewer.getControl().getSize().x / 2;
        if (x <= middle) {
            this.fileOpened(Side.LEFT, file);
        } else {
            this.fileOpened(Side.RIGHT, file);
        }
    }

    public void setFocus() {
        this.diagramViewer.getControl().setFocus();
    }

    private TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
            this.editingDomain.setID("net.miowb.diagram.EditingDomain");
        }
        return this.editingDomain;
    }

    @Override
    public void fileOpened(Side origin, IFile file) {
        if (!file.getFileExtension().equals("mio")) {
            return;
        }
        DiagramLoader dl = new DiagramLoader(this.getEditingDomain(), file);
        if (dl.getDiagram() == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Load error.", (String)"Unable to load mio diagram file.");
            return;
        }
        ModalIOAutomaton mio = (ModalIOAutomaton)dl.getDiagram().getElement();
        AdapterFactory af = ((AdapterFactoryEditingDomain)this.editingDomain).getAdapterFactory();
        IItemPropertySource ips = (IItemPropertySource)af.adapt((Notifier)mio, IItemPropertySource.class);
        PropertySource ps = new PropertySource((Object)mio, ips);
        ps.setPropertyValue((Object)MioPackage.Literals.MODAL_IO_AUTOMATON__NAME, (Object)file.getName());
        this.setInput(origin, dl.getDiagram());
        this.reset();
    }

    private void setInput(Side origin, DiagramImpl diagram) {
        this.diagramViewer.setInput(origin, diagram);
        ModalIOAutomaton mio = null;
        if (diagram != null) {
            mio = (ModalIOAutomaton)diagram.getElement();
        }
        switch (origin) {
            case LEFT: {
                this.fLeftSelectionPanel.setSelection(mio);
                break;
            }
            case RIGHT: {
                this.fRightSelectionPanel.setSelection(mio);
            }
        }
    }

    @Override
    public void clear(Side side) {
        this.reset();
        this.setInput(side, null);
    }

    @Override
    public void middleButtonPressed(IMioOperation operation) {
        this.reset();
        MessageManager.setSendToShell((boolean)false);
        if (operation instanceof IMioRefinementOperation) {
            this.refine((IMioRefinementOperation)operation);
        }
        if (operation instanceof IMioBinaryCompatibilityOperation) {
            this.checkCompatibility((IMioBinaryCompatibilityOperation)operation);
        }
        if (operation.getName().equals("Clear")) {
            this.diagramViewer.clearMarkersAndRefinement();
            this.reset();
        }
        MessageManager.setSendToShell((boolean)true);
    }

    private void refine(IMioRefinementOperation op) {
        if (!this.diagramViewer.hasTwoGraphs()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Refinement Check", (String)"Refinement check needs two automata.");
            return;
        }
        this.diagramViewer.clearMarkersAndRefinement();
        ModalIOAutomaton abstractSpec = this.diagramViewer.getAutomaton(Side.RIGHT);
        ModalIOAutomaton concreteSpec = this.diagramViewer.getAutomaton(Side.LEFT);
        RefinementResult result = op.checkRefinement(abstractSpec, concreteSpec, false, false);
        this.fLabel.setText(op.getName());
        String messages = MessageManager.getMessagesAsString();
        switch (result.getfResultType()) {
            case MISMATCHING_ACTIONS: {
                this.setRed();
                this.openErrorDialog("Refinement Check", messages);
                break;
            }
            case SUCCESS: {
                this.setGreen();
                RefinementRelation positiveResult = result.getPositiveResult();
                for (StatePair pair : positiveResult.getStatePairs()) {
                    this.diagramViewer.addRefinementLink(pair.getS2(), pair.getS1());
                }
                break;
            }
            case REFINEMENT_ERROR: {
                this.setRed();
                List problemPaths = result.getNegativeResults();
                if (problemPaths.size() <= 0) break;
                this.setProblemPaths(problemPaths);
                this.problemPathSelected(this.fProblemPaths.get(0));
            }
        }
    }

    private void openErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void checkCompatibility(IMioBinaryCompatibilityOperation comp) {
        if (!this.diagramViewer.hasTwoGraphs()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Compatibility Check", (String)"Compatibility check needs two automata.");
            return;
        }
        this.diagramViewer.clearMarkersAndRefinement();
        ModalIOAutomaton s1 = this.diagramViewer.getAutomaton(Side.LEFT);
        ModalIOAutomaton s2 = this.diagramViewer.getAutomaton(Side.RIGHT);
        this.fLabel.setText(comp.getName());
        try {
            CompatibilityResult cResult = comp.checkCompatibility(s1, s2);
            String messages = MessageManager.getMessagesAsString();
            switch (cResult.getResultType()) {
                case SUCCESS: {
                    this.setGreen();
                    List resultingStates = cResult.getResultingStates();
                    for (StatePair statePair : resultingStates) {
                        this.diagramViewer.addRefinementLink(statePair.getS1(), statePair.getS2());
                    }
                    break;
                }
                case MISMATCHING_ACTIONS: {
                    this.setRed();
                    if (cResult.getIncomposableActions() != null) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Compatibility Check", (String)messages);
                    }
                    break;
                }
                case ERROR: {
                    this.setRed();
                    StatePair problemPair = cResult.getProblematicStatePair();
                    this.diagramViewer.markProblematic(problemPair.getS1());
                    this.diagramViewer.markProblematic(problemPair.getS2());
                    SingleActionPath problemPath = cResult.getProblemPath();
                    for (Transition t : problemPath.getTransitions()) {
                        this.diagramViewer.markProblematic(t);
                    }
                }
            }
        }
        catch (MioException e) {
            MioDiagramCustomPlugin.logError(e);
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Mio", (String)e.getMessage());
        }
    }

    @Override
    public void relayout(Side side) {
        this.diagramViewer.applyLayout(side);
    }

    @Override
    public void hide(Side side, boolean same) {
        ModalIOAutomaton automatonToAdjust = this.diagramViewer.getAutomaton(side);
        if (automatonToAdjust == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Problem in Adjustment", (String)"Cannot adjust alphabet - no automaton given.");
            return;
        }
        Side other = side == Side.LEFT ? Side.RIGHT : Side.LEFT;
        ModalIOAutomaton alphabetToUse = this.diagramViewer.getAutomaton(other);
        if (alphabetToUse == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Problem in Adjustment", (String)"Cannot adjust alphabet - no automaton with alphabet to adjust to.");
            return;
        }
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)new AutomatonUtilsHideCommand(this.getEditingDomain(), automatonToAdjust, alphabetToUse, same), (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ModalioDiagramEditorPlugin.getInstance().logError("Unable to execute hide action", (Throwable)e);
        }
    }

    @Override
    public void problemPathSelected(RefinementRelation problemPath) {
        this.diagramViewer.clearMarkersAndRefinement();
        Set allPairs = problemPath.getStatePairs();
        for (StatePair pair : allPairs) {
            State left = pair.getS2();
            State right = pair.getS1();
            this.diagramViewer.addRefinementLink(left, right);
        }
        StatePair lastPair = problemPath.getPairWithoutProvided();
        if (lastPair != null) {
            this.diagramViewer.markProblematic(lastPair.getS2());
            this.diagramViewer.markProblematic(lastPair.getS1());
        }
        Set allTransitions = problemPath.getFlattenedTransitions();
        for (Transition transition : allTransitions) {
            this.diagramViewer.markProblematic(transition);
        }
    }

    private Shell getShell() {
        return this.getSite().getShell();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (Transition oldT : this.lastHighlightedPath) {
            this.diagramViewer.reset(oldT);
        }
        this.lastHighlightedPath.clear();
        if (event.getSelection() instanceof IStructuredSelection) {
            Transition modelObject;
            Set involvements;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (this.fRefinementRelation != null && selection.size() == 1 && selection.getFirstElement() instanceof TransitionEditPart && (involvements = this.fRefinementRelation.getInvolvements(modelObject = (Transition)((TransitionEditPart)selection.getFirstElement()).resolveSemanticElement())) != null) {
                for (SingleActionPath singleActionPath : involvements) {
                    for (Transition t : singleActionPath.getTransitions()) {
                        this.diagramViewer.mark(t);
                        this.lastHighlightedPath.add(t);
                    }
                }
            }
        }
    }

    @Override
    public void save(Side side) {
        ModalIOAutomaton mio = this.diagramViewer.getAutomaton(side);
        if (mio != null) {
            FileSaveDialog d = new FileSaveDialog(this.getShell(), "Save", "Save the MIO");
            d.open();
            IFile f = (IFile)d.getResult()[0];
            try {
                Diagram diagram = this.diagramViewer.getDiagram(side);
                this.setInput(side, null);
                MioEMFHelper.store((IFile)f, (ModalIOAutomaton)mio, (EObject)diagram);
                this.fileOpened(side, f);
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)"Error while saving Mio", (String)"Could not save the MIO.");
            }
        }
    }

    public void setGreen() {
        this.setAllBackgrounds(this.getShell().getDisplay().getSystemColor(5));
    }

    public void setRed() {
        this.setAllBackgrounds(this.getShell().getDisplay().getSystemColor(3));
    }

    public void setGray() {
        this.setAllBackgrounds(this.getShell().getDisplay().getSystemColor(15));
    }

    private void setAllBackgrounds(Color color) {
        this.fStatusComposite.setBackground(color);
        this.fLabel.setBackground(color);
    }

    public static enum ViewButtons {
        CLEAR,
        PRUNE,
        LAYOUT,
        ALPHABET;

    }
}

