/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.view;

import java.util.ArrayList;
import java.util.List;
import net.miowb.views.view.ActionListener;
import net.miowb.workbench.operations.IMioOperation;
import net.miowb.workbench.operations.OperationManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MiddlePanel
extends Composite {
    private Composite fButtons;
    private List<ActionListener> fListeners = new ArrayList<ActionListener>();

    public MiddlePanel(Composite parent) {
        super(parent, 2048);
        this.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this);
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo((Composite)this);
        this.fButtons = new Composite((Composite)this, 0);
        this.fButtons.setBackground(this.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.fButtons);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.fButtons);
        final ToolBar bar1 = new ToolBar(this.fButtons, 64);
        GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)bar1);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo((Composite)bar1);
        bar1.setBackground(this.getDisplay().getSystemColor(1));
        bar1.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = bar1.getClientArea();
                Point size = bar1.computeSize(rect.width, -1);
                bar1.setSize(size);
            }
        });
        this.createDDToolbarButton(bar1, "Refinement", OperationManager.getRefinements());
        this.createDDToolbarButton(bar1, "Compatibility", OperationManager.getCompatibilities());
        this.createNNToolbarButton(bar1, "Clear");
    }

    private void createNNToolbarButton(ToolBar bar, final String name) {
        ToolItem item = new ToolItem(bar, 8);
        item.setText(name);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MiddlePanel.this.informListeners(new IMioOperation(){

                    public String getName() {
                        return name;
                    }
                });
            }
        });
    }

    private void createDDToolbarButton(final ToolBar toolBar, String name, List<? extends IMioOperation> operations) {
        final Menu menu = new Menu((Decorations)toolBar.getShell(), 8);
        final ToolItem item = new ToolItem(toolBar, 8);
        item.setText(name);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = item.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        if (operations.isEmpty()) {
            item.setEnabled(false);
        }
        for (final IMioOperation iMioOperation : operations) {
            MenuItem innerItem = new MenuItem(menu, 8);
            innerItem.setText(iMioOperation.getName());
            innerItem.setData((Object)iMioOperation);
            innerItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MiddlePanel.this.informListeners(iMioOperation);
                }
            });
        }
    }

    protected void informListeners(IMioOperation operation) {
        for (ActionListener l : this.fListeners) {
            l.middleButtonPressed(operation);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.fListeners.add(listener);
    }
}

