/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.view;

import java.util.ArrayList;
import java.util.List;
import net.miowb.common.FileLoadDialog;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.views.view.ActionListener;
import net.miowb.views.view.Side;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class FileSelectionComposite
extends Composite {
    private static final String SELECT_AN_AUTOMATON = "Click to select MIO...";
    private Text fSelectedAutomaton;
    private List<ActionListener> fListeners = new ArrayList<ActionListener>();
    private Side fSide;
    private FileLoadDialog fLoadDialog;
    protected IFile fLastResult;

    public FileSelectionComposite(Composite parent, Side left) {
        super(parent, 0);
        this.fSide = left;
        this.setBackground(parent.getBackground());
        GridDataFactory.swtDefaults().grab(false, false).align(4, 0x1000000).hint(-1, 30).applyTo((Control)this);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).equalWidth(false).applyTo((Composite)this);
        this.fSelectedAutomaton = new Text((Composite)this, 2056);
        GridDataFactory.swtDefaults().hint(170, -1).applyTo((Control)this.fSelectedAutomaton);
        this.fSelectedAutomaton.setText(SELECT_AN_AUTOMATON);
        this.fSelectedAutomaton.setBackground(this.getBackground());
        this.fSelectedAutomaton.setEditable(false);
        this.fSelectedAutomaton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (FileSelectionComposite.this.fLoadDialog == null) {
                    FileSelectionComposite.this.fLoadDialog = new FileLoadDialog(FileSelectionComposite.this.getShell(), "MIO Selection", "Plase select a .mio or .mio_diagram file...");
                    FileSelectionComposite.this.fLoadDialog.setAllowMultiple(false);
                    FileSelectionComposite.this.fLoadDialog.setBlockOnOpen(true);
                }
                if (FileSelectionComposite.this.fLastResult instanceof IFile) {
                    FileSelectionComposite.this.fLoadDialog.setInitialSelection((Object)FileSelectionComposite.this.fLastResult);
                }
                if (FileSelectionComposite.this.fLoadDialog.open() == 0) {
                    FileSelectionComposite.this.fLastResult = (IFile)FileSelectionComposite.this.fLoadDialog.getFirstResult();
                    for (ActionListener listener : FileSelectionComposite.this.fListeners) {
                        listener.fileOpened(FileSelectionComposite.this.fSide, FileSelectionComposite.this.fLastResult);
                    }
                }
            }
        });
    }

    public void addActionListener(ActionListener listener) {
        this.fListeners.add(listener);
    }

    public void setSelection(ModalIOAutomaton tom) {
        if (tom == null) {
            this.fSelectedAutomaton.setText(SELECT_AN_AUTOMATON);
        } else {
            this.fSelectedAutomaton.setText(tom.getName());
        }
    }
}

