/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.view;

import java.io.IOException;
import java.util.HashMap;
import net.miowb.model.mio.diagram.part.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;

public class DiagramLoader {
    private TransactionalEditingDomain domain;
    private Resource resource;
    private DiagramImpl diagram;

    public DiagramLoader(TransactionalEditingDomain domain, IFile file) {
        this.domain = domain;
        this.diagram = this.getDiagramFromFile(file);
    }

    public TransactionalEditingDomain getDomain() {
        return this.domain;
    }

    public Resource getResource() {
        return this.resource;
    }

    public DiagramImpl getDiagram() {
        return this.diagram;
    }

    public DiagramImpl getDiagramFromFile(IFile file) {
        URI uri = this.convertToURI(file);
        this.resource = null;
        try {
            this.resource = this.domain.getResourceSet().getResource(uri.trimFragment(), false);
            if (this.resource == null) {
                this.resource = this.domain.getResourceSet().createResource(uri.trimFragment());
            }
            if (this.resource.isLoaded()) {
                this.resource.unload();
            }
            try {
                HashMap options = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                this.resource.load(options);
            }
            catch (IOException iOException) {
                this.resource.unload();
            }
            if (uri.fragment() != null) {
                EObject rootElement = this.resource.getEObject(uri.fragment());
                if (rootElement instanceof DiagramImpl) {
                    return (DiagramImpl)rootElement;
                }
            } else {
                for (Object rootElement : this.resource.getContents()) {
                    if (!(rootElement instanceof DiagramImpl)) continue;
                    return (DiagramImpl)rootElement;
                }
            }
            throw new RuntimeException(Messages.ModalioDocumentProvider_NoDiagramInResourceError);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private URI convertToURI(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }
}

