/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.views.mio2dot.GraphGenerator;
import net.miowb.views.shell.DropHelper;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.contracts.ContractHelpers;
import net.miowb.workbench.shell.Message;
import net.miowb.workbench.shell.MessageManager;
import net.miowb.workbench.shell.MioCommandLine;
import net.miowb.workbench.shell.MioCommandLineObserver;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;

public class ShellWidget
implements VerifyKeyListener,
MioCommandLineObserver {
    private StyledText fText;
    private List<String> fHistory = new ArrayList<String>();
    private int fCmdStart = 2;
    private int fCurrentHistory = 0;
    private MioCommandLine fCommandLine = MioCommandLine.getInstance();
    private String fStringToProcess;
    private boolean fPromptEnabled = true;
    private static final String fPromptSymbol = "> ";

    public ShellWidget(Composite parent) {
        MessageManager.addObserver((MioCommandLineObserver)this);
        MioCommandLine.getInstance().addObserver((MioCommandLineObserver)this);
        this.fText = new StyledText(parent, 2624){};
        this.fText.setText(fPromptSymbol);
        this.fText.setCaretOffset(this.fText.getCharCount());
        this.fText.addVerifyKeyListener((VerifyKeyListener)this);
        this.fText.setFont(new Font((Device)parent.getDisplay(), new FontData("Courier New", 12, 1)));
        DropTarget t = new DropTarget((Control)this.fText, 7);
        t.setTransfer(new Transfer[]{ResourceTransfer.getInstance()});
        t.addDropListener(new DropTargetListener(){
            private IFile file_to_process;

            public void dropAccept(DropTargetEvent event) {
                DropHelper.changeDropOperationToCopy(event);
            }

            public void drop(DropTargetEvent event) {
                if (MioCommandLine.getInstance().isBusy().booleanValue() || !ShellWidget.this.fPromptEnabled) {
                    event.detail = 0;
                    return;
                }
                List<IFile> files = DropHelper.getFilesFromDrop(event);
                if (files == null || files.size() == 0) {
                    event.detail = 0;
                    return;
                }
                ShellWidget.this.fPromptEnabled = false;
                ShellWidget.this.removeCommand();
                int gesamt = 0;
                for (IFile file : files) {
                    EObject content;
                    Resource resource;
                    URI outputURI;
                    ResourceSetImpl set;
                    if (file.getFileExtension().equals("mio")) {
                        set = new ResourceSetImpl();
                        outputURI = ShellWidget.this.convertToURI(file);
                        resource = set.getResource(outputURI, true);
                        content = (EObject)resource.getContents().get(0);
                        if (content == null) continue;
                        if (!(content instanceof ModalIOAutomaton)) {
                            MessageManager.addError((String)"Contents could be read; but was expecting a ModalIOAutomaton in there.");
                            ShellWidget.this.printPrompt();
                            break;
                        }
                        ModalIOAutomaton inputModel = (ModalIOAutomaton)content;
                        MioCommandLine.getInstance().registerMIO(inputModel);
                        if (++gesamt != files.size()) continue;
                        ShellWidget.this.printPrompt();
                        continue;
                    }
                    if (file.getFileExtension().equals("miocontract")) {
                        set = new ResourceSetImpl();
                        outputURI = ShellWidget.this.convertToURI(file);
                        resource = set.getResource(outputURI, true);
                        content = (EObject)resource.getContents().get(0);
                        if (content == null) continue;
                        if (!(content instanceof ModalIOContract)) {
                            MessageManager.addError((String)"Contents could be read; but was expecting a ModalIOContract in there.");
                            ShellWidget.this.printPrompt();
                            break;
                        }
                        ModalIOContract inputContract = (ModalIOContract)content;
                        try {
                            ModalIOContract rc = ContractHelpers.getReducedContract((ModalIOContract)inputContract);
                            MioCommandLine.getInstance().registerContract(rc);
                        }
                        catch (MioException mioException) {
                            MessageManager.addError((String)("Modal contract " + inputContract.getName() + " is inconsistent. Not registered."));
                        }
                        if (++gesamt != files.size()) continue;
                        ShellWidget.this.printPrompt();
                        continue;
                    }
                    if (!file.getFileExtension().equals("miotxt")) continue;
                    this.file_to_process = file;
                    Runnable job = new Runnable(){

                        @Override
                        public void run() {
                            ShellWidget.this.fCommandLine.execute(file_to_process);
                        }
                    };
                    Thread myjob = new Thread(job);
                    myjob.start();
                    break;
                }
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragEnter(DropTargetEvent event) {
                DropHelper.changeDropOperationToCopy(event);
            }
        });
    }

    private void printPrompt() {
        if (!this.fPromptEnabled) {
            this.write(fPromptSymbol);
        }
    }

    private URI convertToURI(IFile file) {
        URI fileURI = null;
        fileURI = file instanceof IFile ? URI.createFileURI((String)file.getLocation().toString()) : URI.createFileURI((String)((File)file).getAbsolutePath());
        return fileURI;
    }

    public void verifyKey(VerifyEvent event) {
        this.fText.showSelection();
        if (MioCommandLine.getInstance().isBusy().booleanValue()) {
            event.doit = false;
            return;
        }
        if (event.keyCode == 0x1000001) {
            if (this.fCurrentHistory != 0 && this.fHistory.size() > 0) {
                this.removeCommand();
                --this.fCurrentHistory;
                this.fText.append(this.fHistory.get(this.fCurrentHistory));
                this.fText.setCaretOffset(this.fText.getCharCount());
            }
            event.doit = false;
        }
        if (event.keyCode == 0x1000002) {
            this.removeCommand();
            if (this.fHistory.size() > 0 && this.fCurrentHistory < this.fHistory.size() - 1) {
                ++this.fCurrentHistory;
                this.fText.append(this.fHistory.get(this.fCurrentHistory));
                this.fText.setCaretOffset(this.fText.getCharCount());
            } else {
                this.fCurrentHistory = this.fHistory.size();
            }
            event.doit = false;
        }
        if (event.keyCode == 0x1000007) {
            int lineAtOffset = this.fText.getLineAtOffset(this.fText.getCaretOffset());
            int lineAtCommand = this.fText.getLineAtOffset(this.fCmdStart);
            if (lineAtCommand == lineAtOffset) {
                this.fText.setCaretOffset(this.fCmdStart);
                event.doit = false;
            }
        }
        if (event.character == '\r' || event.character == '\n') {
            event.doit = false;
            this.enter();
        }
        if ((event.keyCode == 0x1000003 || event.keyCode == 8) && this.fText.getCaretOffset() <= this.fCmdStart) {
            event.doit = false;
        }
        if (this.fText.getCaretOffset() < this.fCmdStart) {
            this.fText.setCaretOffset(this.fText.getCharCount());
        }
    }

    private void writeToTextAsError(Object s) {
        this.writeToText(s, 3, false);
    }

    private void writeToText(Object s, int color, boolean completion) {
        this.writeToText(s, color, 0, completion);
    }

    private void writeToText(final Object s, final int color, final int fontstyle, final boolean completion) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int begin = ShellWidget.this.fText.getCharCount();
                ShellWidget.this.fText.append(s.toString());
                if (completion) {
                    ShellWidget.this.fText.setCaretOffset(ShellWidget.this.fText.getCharCount());
                } else {
                    ShellWidget.this.fCmdStart = ShellWidget.this.fText.getCharCount();
                    ShellWidget.this.fText.setCaretOffset(ShellWidget.this.fCmdStart);
                    StyleRange style2 = new StyleRange();
                    style2.start = begin;
                    style2.length = ShellWidget.this.fCmdStart - begin;
                    style2.foreground = Display.getCurrent().getSystemColor(color);
                    style2.fontStyle = fontstyle;
                    ShellWidget.this.fText.setStyleRange(style2);
                }
                if (completion) {
                    ShellWidget.this.fText.setSelection(ShellWidget.this.fText.getCharCount());
                } else {
                    ShellWidget.this.fText.setSelection(ShellWidget.this.fCmdStart);
                }
                ShellWidget.this.fText.showSelection();
            }
        });
    }

    public void write(String o) {
        this.writeToText(o, 2, false);
    }

    public void writeForUser(String o) {
        this.writeToText(o, 2, true);
    }

    public Control getControl() {
        return this.fText;
    }

    private Shell getShell() {
        return this.getControl().getShell();
    }

    public void zoomOut() {
        Font currFont = this.fText.getFont();
        FontData[] fontdata = currFont.getFontData();
        fontdata[0].getHeight();
    }

    public void zoomIn() {
        Font currFont = this.fText.getFont();
        FontData[] fontdata = currFont.getFontData();
        fontdata[0].getHeight();
    }

    private String getCmd() {
        return this.fText.getCharCount() <= this.fCmdStart ? "" : this.fText.getText(this.fCmdStart, this.fText.getCharCount() - 1);
    }

    private void enter() {
        String command = this.getCmd();
        if (!command.isEmpty()) {
            if (this.fHistory.size() > 0 && command.startsWith(this.fHistory.get(this.fHistory.size() - 1))) {
                this.fHistory.remove(this.fHistory.size() - 1);
            }
            this.fHistory.add(command);
            this.fCurrentHistory = this.fHistory.size();
        }
        this.acceptLine(command);
    }

    private void acceptLine(String line) {
        this.fPromptEnabled = false;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ShellWidget.this.write("\n");
            }
        });
        this.fStringToProcess = line;
        try {
            if (this.fStringToProcess.startsWith("view ")) {
                String cmd = this.fStringToProcess.substring(5);
                String[] list = cmd.split("\\.");
                ModalIOAutomaton mio = list.length > 1 && list[1].equals("env") ? MioCommandLine.getInstance().getAssumption(list[0]) : (list.length > 1 && list[1].equals("spec") ? MioCommandLine.getInstance().getGuarantee(list[0]) : MioCommandLine.getInstance().get(list[0]));
                if (mio == null) {
                    MessageManager.add((String)(String.valueOf(list[0]) + " not found."));
                    return;
                }
                GraphGenerator mGraphGenerator = new GraphGenerator();
                if (mio != null) {
                    mGraphGenerator.generateGraph(mio);
                }
                MessageManager.add((String)"OK");
                return;
            }
        }
        catch (Exception exception) {
            MessageManager.addError((String)"There were problems with generating the image.");
            return;
        }
        Runnable job = new Runnable(){

            @Override
            public void run() {
                MioCommandLine.getInstance().setBusy(Boolean.valueOf(true));
                long startTime = System.currentTimeMillis();
                ShellWidget.this.fCommandLine.execute(ShellWidget.this.fStringToProcess);
                long endTime = System.currentTimeMillis();
                MessageManager.addVerbose((String)("Time elapsed: " + (endTime - startTime) / 1000000000L + " s"));
                MioCommandLine.getInstance().setBusy(Boolean.valueOf(false));
            }
        };
        Thread myjob = new Thread(job);
        myjob.start();
    }

    private void writeToText(List<Message> mes) {
        for (Message m : mes) {
            this.writeToText(m);
        }
    }

    private void writeToText(Message mes) {
        switch (mes.getType()) {
            case NORMAL: {
                this.writeToText(String.valueOf(mes.getMessage()) + "\n", 9, false);
                break;
            }
            case ERROR: {
                this.writeToText(String.valueOf(mes.getMessage()) + "\n", 3, false);
                break;
            }
            case VERBOSE: {
                if (!MioCommandLine.getInstance().isfVerboseMode()) break;
                this.writeToText(String.valueOf(mes.getMessage()) + "\n", 16, false);
                break;
            }
            case WARNING: {
                this.writeToText(String.valueOf(mes.getMessage()) + "\n", 9, false);
            }
        }
    }

    private void removeCommand() {
        if (this.fCmdStart < this.fText.getCharCount()) {
            this.fText.setSelection(this.fCmdStart, this.fText.getCharCount());
            this.fText.cut();
        }
    }

    public void setFocus() {
        this.fText.setFocus();
    }

    public void clear() {
        this.fText.setText(fPromptSymbol);
        this.fCmdStart = 2;
        this.fText.setCaretOffset(this.fCmdStart);
        this.fPromptEnabled = true;
    }

    public void refresh() {
        Message m;
        if (MioCommandLine.getInstance().isBusy().booleanValue()) {
            this.fPromptEnabled = false;
        }
        while ((m = (Message)MessageManager.getMessages().poll()) != null) {
            this.writeToText(m);
        }
        if (!MioCommandLine.getInstance().isBusy().booleanValue() && !this.fPromptEnabled) {
            this.write(fPromptSymbol);
            this.fPromptEnabled = true;
        }
    }
}

