/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.shell;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MioInputDialog
extends Dialog {
    private String fInput;
    private String fText;

    public MioInputDialog(Shell parent, String text) {
        this(parent, 67680);
        this.fText = text;
    }

    public MioInputDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("Input Dialog");
    }

    public String getInput() {
        return this.fInput;
    }

    public String open(String initial_text) {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        this.createContents(shell, initial_text);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.fInput;
    }

    private void createContents(final Shell shell, String initial_text) {
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).spacing(5, 5).applyTo((Composite)shell);
        Label label = new Label((Composite)shell, 0);
        label.setText(this.fText);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        final Text text = new Text((Composite)shell, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        text.setText(initial_text);
        text.setSelection(text.getCharCount());
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText("Cancel");
        data = new GridData(768);
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MioInputDialog.this.fInput = null;
                shell.close();
            }
        });
        Button ok = new Button((Composite)shell, 8);
        ok.setText("OK");
        data = new GridData(768);
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MioInputDialog.this.fInput = text.getText();
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
    }
}

