/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.shell;

import net.miowb.views.shell.ShellWidget;
import net.miowb.workbench.shell.MessageManager;
import net.miowb.workbench.shell.MioCommandLine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class CommandLineView
extends ViewPart {
    public static final String ID = "net.miowb.views.shell.CommandLineView";
    private ShellWidget fWidget;
    private Action fClearAction;
    private Action fVerboseToogleAction;
    private Action fResetAction;

    public void createPartControl(Composite parent) {
        this.fWidget = new ShellWidget(parent);
        this.createActions();
        this.createToolbar();
    }

    private void createActions() {
        this.fClearAction = new Action("Clear"){

            public void run() {
                CommandLineView.this.fWidget.clear();
            }
        };
        this.fVerboseToogleAction = new Action("Verbose Mode"){

            public void run() {
                MioCommandLine.getInstance().setfVerboseMode(!MioCommandLine.getInstance().isfVerboseMode());
                this.setChecked(MioCommandLine.getInstance().isfVerboseMode());
            }
        };
        this.fVerboseToogleAction.setChecked(MioCommandLine.getInstance().isfVerboseMode());
        this.fResetAction = new Action("Reset"){

            public void run() {
                MessageManager.setEnabled((Boolean)true);
                MioCommandLine.getInstance().resetVariables();
                CommandLineView.this.fWidget.clear();
                MioCommandLine.getInstance().setBusy(Boolean.valueOf(false));
            }
        };
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.fClearAction);
        mgr.add((IAction)this.fVerboseToogleAction);
        mgr.add((IAction)this.fResetAction);
    }

    public void setFocus() {
        this.fWidget.setFocus();
    }
}

