/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.sheet;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public abstract class EditPartSection
extends AbstractPropertySection
implements NotificationListener {
    protected IGraphicalEditPart editPart;
    private TransactionalEditingDomain editingDomain;
    private List<ListenFeature> listeners;
    public static final int SECTION_LABEL_WIDTH = 110;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof IGraphicalEditPart));
        this.editPart = (IGraphicalEditPart)input;
    }

    public EObject getSemanticObject() {
        return this.editPart.resolveSemanticElement();
    }

    public void aboutToBeShown() {
        this.addListeners();
    }

    public void aboutToBeHidden() {
        this.removeListeners();
    }

    protected abstract List<ListenFeature> getListenFeatures();

    protected void addListeners() {
        if (this.listeners != null) {
            this.removeListeners();
        }
        this.listeners = this.getListenFeatures();
        for (ListenFeature f : this.listeners) {
            this.getDiagramEventBroker().addNotificationListener(f.object, f.feature, (NotificationListener)this);
        }
    }

    protected void removeListeners() {
        if (this.listeners == null) {
            return;
        }
        for (ListenFeature f : this.listeners) {
            this.getDiagramEventBroker().removeNotificationListener(f.object, (Object)f.feature, (NotificationListener)this);
        }
        this.listeners = null;
    }

    protected void updateListeners() {
        this.removeListeners();
        this.addListeners();
    }

    public IPropertySource getPropertySource(Object object) {
        IItemPropertySource ips;
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        AdapterFactory af = this.getAdapterFactory();
        if (af != null && (ips = (IItemPropertySource)af.adapt(object, IItemPropertySource.class)) != null) {
            return new PropertySource(object, ips);
        }
        if (object instanceof IAdaptable) {
            return (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
        }
        return null;
    }

    public IItemLabelProvider getLabelProvider(Object object) {
        IItemLabelProvider ilp;
        if (object instanceof IPropertySource) {
            return (IItemLabelProvider)object;
        }
        AdapterFactory af = this.getAdapterFactory();
        if (af != null && (ilp = (IItemLabelProvider)af.adapt(object, IItemLabelProvider.class)) != null) {
            return ilp;
        }
        if (object instanceof IAdaptable) {
            return (IItemLabelProvider)((IAdaptable)object).getAdapter(IItemLabelProvider.class);
        }
        return null;
    }

    protected AdapterFactory getAdapterFactory() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain);
        }
        return null;
    }

    private TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = TransactionUtil.getEditingDomain((EObject)this.editPart.resolveSemanticElement());
        }
        return this.editingDomain;
    }

    protected class ListenFeature {
        public final EObject object;
        public final EStructuralFeature feature;

        ListenFeature(EObject object, EStructuralFeature feature) {
            this.object = object;
            this.feature = feature;
        }
    }
}

