/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.sheet;

import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.views.sheet.EditPartSection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AutomatonStartStateSection
extends EditPartSection {
    private CCombo statesCombo;
    private SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ModalIOAutomaton automaton = (ModalIOAutomaton)AutomatonStartStateSection.this.getSemanticObject();
            Integer index = AutomatonStartStateSection.this.statesCombo.getSelectionIndex();
            State newStart = null;
            if (index != 0) {
                newStart = (State)automaton.getStates().get(index - 1);
            }
            AutomatonStartStateSection.this.getPropertySource(automaton).setPropertyValue((Object)MioPackage.Literals.MODAL_IO_AUTOMATON__START, newStart);
        }
    };

    public void notifyChanged(Notification notification) {
        Object feature = notification.getFeature();
        if (feature.equals(MioPackage.Literals.MODAL_IO_AUTOMATON__START)) {
            this.refresh();
        }
    }

    @Override
    protected List<EditPartSection.ListenFeature> getListenFeatures() {
        ArrayList<EditPartSection.ListenFeature> features = new ArrayList<EditPartSection.ListenFeature>();
        ModalIOAutomaton automaton = (ModalIOAutomaton)this.getSemanticObject();
        features.add(new EditPartSection.ListenFeature(this, (EObject)automaton, (EStructuralFeature)MioPackage.Literals.MODAL_IO_AUTOMATON__START));
        return features;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.statesCombo = this.getWidgetFactory().createCCombo(composite, 8);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 110);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.statesCombo.setLayoutData((Object)data);
        this.statesCombo.addSelectionListener(this.listener);
        CLabel labelLabel = this.getWidgetFactory().createCLabel(composite, "Start State:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.statesCombo, -5);
        data.top = new FormAttachment((Control)this.statesCombo, 0, 0x1000000);
        labelLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        ModalIOAutomaton automaton = (ModalIOAutomaton)this.getSemanticObject();
        State start = automaton.getStart();
        this.statesCombo.removeAll();
        this.statesCombo.add("");
        for (State s : automaton.getStates()) {
            this.statesCombo.add(this.getLabelProvider(s).getText((Object)s));
        }
        this.statesCombo.select(automaton.getStates().indexOf((Object)start) + 1);
    }
}

