/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.sheet;

import java.util.ArrayList;
import java.util.List;
import net.miowb.diagram.contributions.commands.AddActionCommand;
import net.miowb.diagram.contributions.commands.ChangeTransitionActionTypeCommand;
import net.miowb.diagram.contributions.commands.CollapseActionCommand;
import net.miowb.diagram.contributions.commands.DeleteActionsCommand;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.Transition;
import net.miowb.views.sheet.EditPartSection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AutomatonActionListSection
extends EditPartSection {
    private Button fAddButton;
    private Button fDeleteButton;
    private Button fCollapseActionsButton;
    private TableViewer fAlphabetViewer;
    private SelectionListener addListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            InternalAction newAction = MioFactory.eINSTANCE.createInternalAction();
            newAction.setLabel("unnamed Action");
            ModalIOAutomaton mio = (ModalIOAutomaton)AutomatonActionListSection.this.getSemanticObject();
            AutomatonActionListSection.this.editPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)new AddActionCommand((Action)newAction, mio)));
            AutomatonActionListSection.this.refresh();
        }
    };
    private SelectionListener deleteListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection sel = (IStructuredSelection)AutomatonActionListSection.this.fAlphabetViewer.getSelection();
            if (sel != null && sel.getFirstElement() != null) {
                DeleteActionsCommand deleteCommand = new DeleteActionsCommand(sel.toList(), (ModalIOAutomaton)AutomatonActionListSection.this.getSemanticObject());
                AutomatonActionListSection.this.editPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)deleteCommand));
            }
            AutomatonActionListSection.this.refresh();
        }
    };
    private SelectionListener collapseListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CollapseActionCommand collapseActionsCommand = new CollapseActionCommand((ModalIOAutomaton)AutomatonActionListSection.this.getSemanticObject());
            AutomatonActionListSection.this.editPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)collapseActionsCommand));
            AutomatonActionListSection.this.refresh();
        }
    };

    public void notifyChanged(Notification notification) {
        Object feature = notification.getFeature();
        if (feature.equals(MioPackage.Literals.MODAL_IO_AUTOMATON__START)) {
            this.refresh();
        }
    }

    @Override
    protected List<EditPartSection.ListenFeature> getListenFeatures() {
        ArrayList<EditPartSection.ListenFeature> features = new ArrayList<EditPartSection.ListenFeature>();
        ModalIOAutomaton automaton = (ModalIOAutomaton)this.getSemanticObject();
        features.add(new EditPartSection.ListenFeature(this, (EObject)automaton, (EStructuralFeature)MioPackage.Literals.MODAL_IO_AUTOMATON__START));
        return features;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel labelLabel = this.getWidgetFactory().createCLabel(composite, "Actions:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        labelLabel.setLayoutData((Object)data);
        Composite tableView = new Composite(composite, 0);
        tableView.setLayout((Layout)new FillLayout());
        this.fAlphabetViewer = new TableViewer(tableView, 67584);
        this.fAlphabetViewer.getTable().setLinesVisible(true);
        this.fAlphabetViewer.getTable().setHeaderVisible(true);
        this.fAlphabetViewer.setContentProvider((IContentProvider)new AlphabetContentProvider());
        this.fAlphabetViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = AutomatonActionListSection.this.fAlphabetViewer.getSelection();
                AutomatonActionListSection.this.fDeleteButton.setEnabled(!selection.isEmpty());
            }
        });
        TableViewerColumn aType = new TableViewerColumn(this.fAlphabetViewer, 16384);
        aType.getColumn().setText("Action Type");
        aType.getColumn().setWidth(100);
        aType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Action action = (Action)element;
                return AutomatonActionListSection.this.actionToTypeName(action);
            }
        });
        aType.setEditingSupport((EditingSupport)new ActionTypeEditingSupport(this.fAlphabetViewer));
        TableViewerColumn aName = new TableViewerColumn(this.fAlphabetViewer, 16384);
        aName.getColumn().setText("Action Name");
        aName.getColumn().setWidth(150);
        aName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Action action = (Action)element;
                return action.getLabel();
            }
        });
        aName.setEditingSupport((EditingSupport)new ActionNameEditingSupport(this.fAlphabetViewer));
        TableViewerColumn aUsed = new TableViewerColumn(this.fAlphabetViewer, 16384);
        aUsed.getColumn().setText("Used in");
        aUsed.getColumn().setWidth(200);
        aUsed.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Action action = (Action)element;
                return AutomatonActionListSection.this.getUsedString(action);
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)labelLabel, 0);
        data.bottom = new FormAttachment((Control)labelLabel, 200);
        tableView.setLayoutData((Object)data);
        Composite addDel = new Composite(composite, 0);
        RowLayout layout = new RowLayout();
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        addDel.setLayout((Layout)layout);
        addDel.setBackground(parent.getBackground());
        this.fAddButton = new Button(addDel, 8);
        this.fAddButton.setText("Add new unnamed Action");
        this.fAddButton.addSelectionListener(this.addListener);
        this.fDeleteButton = new Button(addDel, 8);
        this.fDeleteButton.setText("Delete");
        this.fDeleteButton.addSelectionListener(this.deleteListener);
        this.fDeleteButton.setEnabled(false);
        this.fCollapseActionsButton = new Button(addDel, 8);
        this.fCollapseActionsButton.setText("Collapse actions");
        this.fCollapseActionsButton.addSelectionListener(this.collapseListener);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)tableView, 4);
        addDel.setLayoutData((Object)data);
    }

    public void refresh() {
        ModalIOAutomaton automaton = (ModalIOAutomaton)this.getSemanticObject();
        this.fAlphabetViewer.setInput((Object)automaton.getActions());
        this.fAlphabetViewer.refresh();
    }

    protected String actionToTypeName(Action action) {
        if (action.isInput()) {
            return "Input";
        }
        if (action.isOutput()) {
            return "Output";
        }
        if (action.isInternal()) {
            return "Internal";
        }
        if (action.isCommunication()) {
            return "Communication";
        }
        return "Unknown Type";
    }

    protected String getUsedString(Action action) {
        StringBuilder s = new StringBuilder();
        int count = 0;
        ModalIOAutomaton automaton = (ModalIOAutomaton)this.getSemanticObject();
        for (Transition t : automaton.getTransitions()) {
            if (!action.equals(t.getAction())) continue;
            if (count > 0) {
                s.append(", ");
            }
            s.append(String.valueOf(t.getFrom().getLabel()) + " -> " + t.getTo().getLabel());
            ++count;
        }
        return s.toString();
    }

    class ActionNameEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;

        public ActionNameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            String label = ((Action)element).getLabel();
            if (label == null) {
                label = "";
            }
            return label;
        }

        protected void setValue(Object element, Object value) {
            Action action = (Action)element;
            IPropertySource properties = AutomatonActionListSection.this.getPropertySource(action);
            properties.setPropertyValue((Object)MioPackage.Literals.ACTION__LABEL, (Object)String.valueOf(value));
            AutomatonActionListSection.this.refresh();
        }
    }

    class ActionTypeEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        ArrayList<String> actionTypes;
        ArrayList<EClass> actionTypeClasses;

        public ActionTypeEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.actionTypes = new ArrayList();
            this.actionTypeClasses = new ArrayList();
            this.viewer = viewer;
            this.actionTypes.add("Internal");
            this.actionTypeClasses.add(MioPackage.Literals.INTERNAL_ACTION);
            this.actionTypes.add("Input");
            this.actionTypeClasses.add(MioPackage.Literals.INPUT_ACTION);
            this.actionTypes.add("Output");
            this.actionTypeClasses.add(MioPackage.Literals.OUTPUT_ACTION);
            this.actionTypes.add("Communication");
            this.actionTypeClasses.add(MioPackage.Literals.COMMUNICATION_ACTION);
        }

        protected CellEditor getCellEditor(Object element) {
            ComboBoxCellEditor cbce = new ComboBoxCellEditor((Composite)this.viewer.getTable(), this.actionTypes.toArray(new String[0]), 8){

                protected Control createControl(Composite parent) {
                    CCombo cc = (CCombo)super.createControl(parent);
                    cc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            this.focusLost();
                        }
                    });
                    return cc;
                }
            };
            return cbce;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            Action action = (Action)element;
            return this.actionTypes.indexOf(AutomatonActionListSection.this.actionToTypeName(action));
        }

        protected void setValue(Object element, Object value) {
            Action action = (Action)element;
            ModalIOAutomaton automaton = (ModalIOAutomaton)AutomatonActionListSection.this.getSemanticObject();
            EClass newType = this.actionTypeClasses.get((Integer)value);
            if (action.eClass().equals(newType)) {
                return;
            }
            ChangeTransitionActionTypeCommand switchCommand = new ChangeTransitionActionTypeCommand(action, automaton, newType);
            AutomatonActionListSection.this.editPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)switchCommand));
            AutomatonActionListSection.this.refresh();
            AutomatonActionListSection.this.fAlphabetViewer.setSelection((ISelection)new StructuredSelection((Object)switchCommand.getNewAction()), true);
        }
    }

    class AlphabetContentProvider
    implements IStructuredContentProvider {
        List<?> fInput;

        AlphabetContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fInput.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fInput = (List)newInput;
        }
    }
}

