/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.sheet;

import java.util.ArrayList;
import java.util.List;
import net.miowb.diagram.contributions.commands.ChangeTransitionActionTypeCommand;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.Transition;
import net.miowb.views.sheet.EditPartSection;
import net.miowb.views.sheet.TransitionPartSection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ActionTypeSection
extends TransitionPartSection {
    private Button fInternalButton;
    private Button fInButton;
    private Button fOutButton;
    private Button fCommunicButton;
    private SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Transition transition = (Transition)ActionTypeSection.this.getSemanticObject();
            ChangeTransitionActionTypeCommand switchCommand = e.widget == ActionTypeSection.this.fInButton ? new ChangeTransitionActionTypeCommand(transition.getAction(), transition.getAutomaton(), MioPackage.Literals.INPUT_ACTION) : (e.widget == ActionTypeSection.this.fOutButton ? new ChangeTransitionActionTypeCommand(transition.getAction(), transition.getAutomaton(), MioPackage.Literals.OUTPUT_ACTION) : (e.widget == ActionTypeSection.this.fCommunicButton ? new ChangeTransitionActionTypeCommand(transition.getAction(), transition.getAutomaton(), MioPackage.Literals.COMMUNICATION_ACTION) : new ChangeTransitionActionTypeCommand(transition.getAction(), transition.getAutomaton(), MioPackage.Literals.INTERNAL_ACTION)));
            ActionTypeSection.this.editPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)switchCommand));
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        Composite inOrOut = new Composite(composite, 0);
        RowLayout layout = new RowLayout();
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        inOrOut.setLayout((Layout)layout);
        inOrOut.setBackground(parent.getBackground());
        this.fInternalButton = new Button(inOrOut, 16);
        this.fInternalButton.setText("Internal Action");
        this.fInternalButton.setBackground(inOrOut.getBackground());
        this.fInButton = new Button(inOrOut, 16);
        this.fInButton.setText("Input Action");
        this.fInButton.setBackground(inOrOut.getBackground());
        this.fOutButton = new Button(inOrOut, 16);
        this.fOutButton.setText("Output Action");
        this.fOutButton.setBackground(inOrOut.getBackground());
        this.fCommunicButton = new Button(inOrOut, 16);
        this.fCommunicButton.setText("Communication Action");
        this.fCommunicButton.setBackground(inOrOut.getBackground());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 110);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        inOrOut.setLayoutData((Object)data);
        CLabel labelLabel = this.getWidgetFactory().createCLabel(composite, "Action Type:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)inOrOut, -5);
        data.top = new FormAttachment((Control)inOrOut, 0, 0x1000000);
        labelLabel.setLayoutData((Object)data);
        this.fInButton.addSelectionListener(this.listener);
        this.fOutButton.addSelectionListener(this.listener);
        this.fInternalButton.addSelectionListener(this.listener);
        this.fCommunicButton.addSelectionListener(this.listener);
    }

    public void notifyChanged(Notification notification) {
        Object feature = notification.getFeature();
        if (feature.equals(MioPackage.Literals.TRANSITION__ACTION)) {
            this.refresh();
        }
    }

    @Override
    protected List<EditPartSection.ListenFeature> getListenFeatures() {
        ArrayList<EditPartSection.ListenFeature> features = new ArrayList<EditPartSection.ListenFeature>();
        Transition transition = (Transition)this.getSemanticObject();
        features.add(new EditPartSection.ListenFeature(this, (EObject)transition, (EStructuralFeature)MioPackage.Literals.TRANSITION__ACTION));
        return features;
    }

    public void refresh() {
        Transition transition = (Transition)this.getSemanticObject();
        Action action = transition.getAction();
        if (action == null) {
            this.setActionTypeEnabled(false);
        } else {
            this.setActionTypeEnabled(true);
            if (action.isInternal()) {
                this.setActionTypeSelection(this.fInternalButton);
            } else if (action.isOutput()) {
                this.setActionTypeSelection(this.fOutButton);
            } else if (action.isInput()) {
                this.setActionTypeSelection(this.fInButton);
            } else if (action.isCommunication()) {
                this.setActionTypeSelection(this.fCommunicButton);
            }
        }
    }

    private void setActionTypeEnabled(boolean enabled) {
        this.fInButton.setEnabled(enabled);
        this.fOutButton.setEnabled(enabled);
        this.fInternalButton.setEnabled(enabled);
        this.fCommunicButton.setEnabled(enabled);
    }

    private void setActionTypeSelection(Button object) {
        this.fInButton.setSelection(object == this.fInButton);
        this.fOutButton.setSelection(object == this.fOutButton);
        this.fInternalButton.setSelection(object == this.fInternalButton);
        this.fCommunicButton.setSelection(object == this.fCommunicButton);
    }
}

