/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.popup.actions;

import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.diagram.edit.parts.ModalIOAutomatonEditPart;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.IMioOperations;
import net.miowb.workbench.operations.OperationManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeterministicCheckAction
implements IObjectActionDelegate {
    private ModalIOAutomatonEditPart fSelectedMio;

    public void run(IAction action) {
        if (this.fSelectedMio == null) {
            return;
        }
        ModalIOAutomaton mio = (ModalIOAutomaton)this.fSelectedMio.resolveSemanticElement();
        IMioOperations ops = OperationManager.getOperations();
        try {
            if (ops.isDeterministic(mio)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Check for determinism", (String)"The MIO is deterministic.");
            } else {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Check for determinism", (String)"The MIO is NOT deterministic.");
            }
        }
        catch (MioException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof StructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof ModalIOAutomatonEditPart) {
            this.fSelectedMio = (ModalIOAutomatonEditPart)structuredSelection.getFirstElement();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

