/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.popup.actions;

import net.miowb.common.SignatureHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddActionDialog
extends Dialog {
    private String fInput;
    private String fText;
    private Button inp;
    private Button outp;
    private Button internal;
    private SignatureHelper.ActionType fSelectedType;

    public SignatureHelper.ActionType getSelectedActionType() {
        return this.fSelectedType;
    }

    public AddActionDialog(Shell parent, String text) {
        this(parent, 67680);
        this.fText = text;
        this.fSelectedType = SignatureHelper.ActionType.INPUT;
    }

    public AddActionDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("Input Dialog");
    }

    public String getInput() {
        return this.fInput;
    }

    public String open(String initial_text) {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        this.createContents(shell, initial_text);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.fInput;
    }

    private void createContents(final Shell shell, String initial_text) {
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).spacing(5, 5).applyTo((Composite)shell);
        Label label = new Label((Composite)shell, 0);
        label.setText(this.fText);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        final Text text = new Text((Composite)shell, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        text.setText(initial_text);
        text.setSelection(text.getCharCount());
        Composite buttons = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).spacing(5, 5).applyTo(buttons);
        this.inp = new Button(buttons, 16);
        this.inp.setText("Input Action");
        this.inp.setSelection(true);
        this.inp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddActionDialog.this.fSelectedType = SignatureHelper.ActionType.INPUT;
            }
        });
        this.outp = new Button(buttons, 16);
        this.outp.setText("Output Action");
        this.outp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddActionDialog.this.fSelectedType = SignatureHelper.ActionType.OUTPUT;
            }
        });
        this.internal = new Button(buttons, 16);
        this.internal.setText("Internal Action");
        this.internal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddActionDialog.this.fSelectedType = SignatureHelper.ActionType.INTERNAL;
            }
        });
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText("Cancel");
        data = new GridData(768);
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddActionDialog.this.fInput = null;
                shell.close();
            }
        });
        Button ok = new Button((Composite)shell, 8);
        ok.setText("OK");
        data = new GridData(768);
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddActionDialog.this.fInput = text.getText();
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
    }
}

