/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.parsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.Transition;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;

public class TransitionLabelParser
implements ISemanticParser {
    public String getEditString(IAdaptable element, int flags) {
        Transition transition = (Transition)element.getAdapter(Transition.class);
        Action action = transition.getAction();
        String value = null;
        if (action != null) {
            value = action.getLabel();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, final String newString, int flags) {
        final EObject target = (EObject)element.getAdapter(EObject.class);
        if (!this.validateValues(target, newString)) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)target);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        IFile affectedFile = WorkspaceSynchronizer.getFile((Resource)target.eResource());
        return new AbstractTransactionalCommand(editingDomain, "Set Values", affectedFile == null ? null : Collections.singletonList(affectedFile)){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return TransitionLabelParser.this.updateValues(target, newString);
            }
        };
    }

    public String getPrintString(IAdaptable element, int flags) {
        Transition transition = (Transition)element.getAdapter(Transition.class);
        Action action = transition.getAction();
        String value = action != null && (action.getLabel() == null || action.getLabel().isEmpty()) ? "unnamed action" : transition.toNiceString();
        return value;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        if (event instanceof Notification) {
            return ((Notification)event).getFeature() == MioPackage.eINSTANCE.getAction_Label();
        }
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    private boolean validateValues(EObject target, String newString) {
        return true;
    }

    private CommandResult updateValues(EObject target, String newString) throws ExecutionException {
        Transition transition = (Transition)target;
        Action targetAction = transition.getAction();
        if (targetAction == null) {
            targetAction = MioFactory.eINSTANCE.createInternalAction();
            transition.getAutomaton().getInternals().add((Object)((InternalAction)targetAction));
            transition.setAction(targetAction);
        }
        targetAction.setLabel(newString);
        return CommandResult.newOKCommandResult();
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElements = new ArrayList<Object>();
        if (element instanceof Transition) {
            Transition transition = (Transition)element;
            semanticElements.add(transition);
            semanticElements.add(transition.getAction());
        }
        return semanticElements;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return ((Notification)notification).getFeature() == MioPackage.eINSTANCE.getTransition_Action();
    }
}

