/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.mio2dot;

import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class Util {
    public static String readFromFile(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) != -1) {
            out.append(new String(buffer, 0, n));
        }
        return out.toString();
    }

    public static File writeToFile(String content, File file) throws IOException {
        String filePath = file.getAbsolutePath();
        FileWriter fileWriter = new FileWriter(filePath);
        fileWriter.write(content);
        fileWriter.close();
        return file;
    }

    public static File convertToImage(File dotFile, String fileNamePrefix, String fileNameExtension) throws IOException, InterruptedException {
        File outputFile = Util.createTempFile(String.valueOf(fileNamePrefix) + "." + fileNameExtension);
        StringBuffer dotCommand = new StringBuffer();
        dotCommand.append("dot -T");
        dotCommand.append(fileNameExtension);
        dotCommand.append(" ");
        dotCommand.append(dotFile.getAbsolutePath());
        dotCommand.append(" -o");
        dotCommand.append(outputFile.getAbsolutePath());
        Process p = Runtime.getRuntime().exec(dotCommand.toString());
        p.getErrorStream();
        p.waitFor();
        return outputFile;
    }

    public static void openFileExternally(File file) throws IOException {
        Desktop desktop = Desktop.getDesktop();
        desktop.open(file);
    }

    public static File createTempFile(String fileName) {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        StringBuffer fileNameBuffer = new StringBuffer();
        fileNameBuffer.append(tempDir);
        fileNameBuffer.append(File.separator);
        fileNameBuffer.append(fileName);
        String filePath = fileNameBuffer.toString();
        File file = new File(filePath);
        return file;
    }
}

