/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.mio2dot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.miowb.common.MioEMFHelper;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.views.Mio2Dot;
import net.miowb.views.imageviewer.views.ImageView;
import net.miowb.views.mio2dot.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class GraphGenerator {
    private static String XML_INPUT_FILE = "ant2dotInput.xml";
    private boolean mXSLFileWritten = false;
    private static String DOT_FILE = "ant2dotOutput.dot";
    private static String IMAGE_FILE_PREFIX = "ant2dot";
    private static String IMAGE_FILE_EXTENSION = "jpg";
    private File mXSLFile;

    public void generateGraph(IFile file) throws CoreException, IOException, TransformerConfigurationException, TransformerException, InterruptedException {
        try {
            ModalIOAutomaton mio = MioEMFHelper.load((IFile)file);
            File dotfile = Util.createTempFile(DOT_FILE);
            Mio2Dot.writeDot(dotfile, mio);
            File imageFile = Util.convertToImage(dotfile, IMAGE_FILE_PREFIX, IMAGE_FILE_EXTENSION);
            Util.openFileExternally(imageFile);
        }
        catch (IOException iOException) {}
    }

    public void generateGraph(ModalIOAutomaton mio) throws IOException, InterruptedException {
        File dotfile = Util.createTempFile(DOT_FILE);
        Mio2Dot.writeDot(dotfile, mio);
        File imageFile = Util.convertToImage(dotfile, IMAGE_FILE_PREFIX, IMAGE_FILE_EXTENSION);
        IViewReference[] iViewReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals("net.miowb.views.imageviewer.views.ImageView")) {
                IWorkbenchPart part = ref.getPart(false);
                ((ImageView)part).imageCanvas.loadImage(imageFile.getPath());
                ((ImageView)part).imageCanvas.showOriginal();
                break;
            }
            ++n2;
        }
    }

    private File getSelectedFile(IFile file) throws CoreException, IOException {
        if (file != null) {
            InputStream in = file.getContents();
            String contents = Util.readFromFile(in);
            File xmlInputFile = Util.createTempFile(XML_INPUT_FILE);
            File inputFile = Util.writeToFile(contents, xmlInputFile);
            return inputFile;
        }
        throw new IOException("Null file.");
    }

    public void generateGraph(ModalIOContract mioContract) throws IOException, InterruptedException {
        File dotfile = Util.createTempFile(DOT_FILE);
        Mio2Dot.writeDot(dotfile, mioContract);
        File imageFile = Util.convertToImage(dotfile, IMAGE_FILE_PREFIX, IMAGE_FILE_EXTENSION);
        IViewReference[] iViewReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals("net.miowb.views.imageviewer.views.ImageView")) {
                IWorkbenchPart part = ref.getPart(false);
                ((ImageView)part).imageCanvas.loadImage(imageFile.getPath());
                ((ImageView)part).imageCanvas.fitCanvas();
                break;
            }
            ++n2;
        }
    }
}

