/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;

public class MioDefaultLayout
implements Runnable {
    private final List<List<GraphicalEditPart>> fLines = new ArrayList<List<GraphicalEditPart>>();
    private final HashMap<GraphicalEditPart, Node> partNodeMap;
    private final GraphicalEditPart startNode;
    private final Set<ConnectionEditPart> relationshipsToConsider;
    private final HashMap<ConnectionEditPart, Integer> backlinks = new HashMap();
    private final ArrayList<ConnectionEditPart> forwardlinks = new ArrayList();

    public MioDefaultLayout(GraphicalEditPart startNode, HashMap<GraphicalEditPart, Node> partNodeMap, Set<ConnectionEditPart> relationshipsToConsider) {
        this.startNode = startNode;
        this.partNodeMap = partNodeMap;
        this.relationshipsToConsider = relationshipsToConsider;
        this.applyLayout(startNode, partNodeMap.keySet(), relationshipsToConsider);
    }

    public void applyLayout(GraphicalEditPart startNode, Set<GraphicalEditPart> entitiesToLayout, Set<ConnectionEditPart> relationshipsToConsider) {
        this.fLines.clear();
        this.backlinks.clear();
        this.forwardlinks.clear();
        LinkedHashSet<GraphicalEditPart> alreadyHandled = new LinkedHashSet<GraphicalEditPart>();
        ArrayList<GraphicalEditPart> firstLine = new ArrayList<GraphicalEditPart>();
        firstLine.add(startNode);
        alreadyHandled.add(startNode);
        this.fLines.add(firstLine);
        Set<GraphicalEditPart> nexts = this.getNexts(startNode, alreadyHandled, relationshipsToConsider);
        while (!nexts.isEmpty()) {
            LinkedHashSet<GraphicalEditPart> nexts2 = new LinkedHashSet<GraphicalEditPart>();
            ArrayList<GraphicalEditPart> currentLine = new ArrayList<GraphicalEditPart>();
            for (GraphicalEditPart nextEl : nexts) {
                currentLine.add(nextEl);
                alreadyHandled.add(nextEl);
            }
            this.fLines.add(currentLine);
            for (GraphicalEditPart nextEl : nexts) {
                Set<GraphicalEditPart> news = this.getNexts(nextEl, alreadyHandled, relationshipsToConsider);
                for (GraphicalEditPart layoutEntity2 : news) {
                    nexts2.add(layoutEntity2);
                }
            }
            nexts = nexts2;
        }
    }

    private Set<GraphicalEditPart> getNexts(GraphicalEditPart layoutEntity, Set<GraphicalEditPart> alreadyHandled, Set<ConnectionEditPart> relationshipsToConsider) {
        LinkedHashSet<GraphicalEditPart> e = new LinkedHashSet<GraphicalEditPart>();
        for (ConnectionEditPart ship : relationshipsToConsider) {
            if (!ship.getSource().equals(layoutEntity)) continue;
            GraphicalEditPart destination = (GraphicalEditPart)ship.getTarget();
            if (alreadyHandled.contains(destination)) {
                int hops = this.getHops(this.fLines, destination);
                this.backlinks.put(ship, hops);
                continue;
            }
            this.forwardlinks.add(ship);
            e.add(destination);
        }
        return e;
    }

    private int getHops(List<List<GraphicalEditPart>> lines, GraphicalEditPart destination) {
        int hops = 0;
        int i = lines.size() - 1;
        while (i >= 0) {
            ++hops;
            List<GraphicalEditPart> list = lines.get(i);
            for (GraphicalEditPart GraphicalEditPart2 : list) {
                if (!GraphicalEditPart2.equals(destination)) continue;
                return hops;
            }
            --i;
        }
        return 1;
    }

    @Override
    public void run() {
        Command command;
        SetAllBendpointRequest request;
        Point from;
        int widest = 0;
        int lineY = 30;
        int element_width = 0;
        int element_height = 0;
        for (List<GraphicalEditPart> line : this.fLines) {
            if (line.size() <= widest) continue;
            widest = line.size();
        }
        for (GraphicalEditPart gep : this.partNodeMap.keySet()) {
            Dimension d = gep.getFigure().getSize();
            if (d.width <= element_width) continue;
            element_width = d.width;
        }
        for (List<GraphicalEditPart> line : this.fLines) {
            int elementsInHere = line.size();
            int startOffset = (int)((double)(widest - elementsInHere) * (double)(element_width + 60) / 2.0);
            int elNo = 0;
            for (GraphicalEditPart gep : line) {
                Dimension d = gep.getFigure().getSize();
                if (d.height <= element_height) continue;
                element_height = d.height;
            }
            for (GraphicalEditPart layoutEntity : line) {
                int entityX = 50 + startOffset + elNo * (element_width + 60);
                int entityY = lineY;
                Node node = this.partNodeMap.get(layoutEntity);
                Bounds bounds = (Bounds)node.getLayoutConstraint();
                bounds.setX(entityX);
                bounds.setY(entityY);
                node.setLayoutConstraint((LayoutConstraint)bounds);
                ++elNo;
            }
            lineY += element_height + 60;
        }
        for (ConnectionEditPart cep : this.forwardlinks) {
            from = this.getCenterForEditPart((GraphicalEditPart)cep.getSource());
            Point to = this.getCenterForEditPart((GraphicalEditPart)cep.getTarget());
            PointList pointList = new PointList();
            request = new SetAllBendpointRequest("set_all_connection_bendpoint", pointList, from, to);
            command = cep.getCommand((Request)request);
            command.execute();
        }
        for (ConnectionEditPart cep : this.backlinks.keySet()) {
            from = this.getCenterForEditPart((GraphicalEditPart)cep.getSource());
            Point to = this.getCenterForEditPart((GraphicalEditPart)cep.getTarget());
            PointList pointList = new PointList();
            if (Math.abs(from.x - to.x) > 5 && Math.abs(from.y - to.y) > 5) {
                pointList.addPoint(from.x, to.y);
            }
            request = new SetAllBendpointRequest("set_all_connection_bendpoint", pointList, from, to);
            command = cep.getCommand((Request)request);
            command.execute();
        }
    }

    private Point getCenterForEditPart(GraphicalEditPart gep) {
        Node n = this.partNodeMap.get(gep);
        Bounds b = (Bounds)n.getLayoutConstraint();
        Dimension d = gep.getFigure().getSize();
        Rectangle r = new Rectangle(b.getX(), b.getY(), d.width, d.height);
        return r.getCenter();
    }
}

