/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.imageviewer.actions;

import net.miowb.views.imageviewer.views.ImageView;
import net.miowb.views.imageviewer.views.SWTImageCanvas;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class PushActionDelegate
implements IViewActionDelegate {
    public ImageView view = null;
    public String id;

    public void init(IViewPart viewPart) {
        if (viewPart instanceof ImageView) {
            this.view = (ImageView)viewPart;
        }
    }

    public void run(IAction action) {
        String id = action.getId();
        SWTImageCanvas imageCanvas = this.view.imageCanvas;
        if (id.equals("toolbar.open")) {
            imageCanvas.onFileOpen();
            return;
        }
        if (imageCanvas.getSourceImage() == null) {
            return;
        }
        if (id.equals("toolbar.zoomin")) {
            imageCanvas.zoomIn();
            return;
        }
        if (id.equals("toolbar.zoomout")) {
            imageCanvas.zoomOut();
            return;
        }
        if (id.equals("toolbar.fit")) {
            imageCanvas.fitCanvas();
            return;
        }
        if (id.equals("toolbar.rotate")) {
            ImageData src = imageCanvas.getImageData();
            if (src == null) {
                return;
            }
            PaletteData srcPal = src.palette;
            PaletteData destPal = srcPal.isDirect ? new PaletteData(srcPal.redMask, srcPal.greenMask, srcPal.blueMask) : new PaletteData(srcPal.getRGBs());
            ImageData dest = new ImageData(src.height, src.width, src.depth, destPal);
            int i = 0;
            while (i < src.width) {
                int j = 0;
                while (j < src.height) {
                    int pixel = src.getPixel(i, j);
                    dest.setPixel(j, src.width - 1 - i, pixel);
                    ++j;
                }
                ++i;
            }
            imageCanvas.setImageData(dest);
            return;
        }
        if (id.equals("toolbar.original")) {
            imageCanvas.showOriginal();
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

