/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.commands;

import java.util.HashMap;
import java.util.HashSet;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.diagram.edit.parts.ModalIOAutomatonEditPart;
import net.miowb.model.mio.diagram.edit.parts.StateEditPart;
import net.miowb.model.mio.diagram.edit.parts.TransitionEditPart;
import net.miowb.views.layout.MioDefaultLayout;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;

public class LayoutDiagramCommand
extends AbstractTransactionalCommand {
    private ModalIOAutomatonEditPart selectedElement;

    public LayoutDiagramCommand(ModalIOAutomatonEditPart selectedElement) {
        super(TransactionUtil.getEditingDomain((EObject)selectedElement.resolveSemanticElement()), "Strongly Minimize", null);
        this.selectedElement = selectedElement;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ModalIOAutomaton mio = (ModalIOAutomaton)this.selectedElement.resolveSemanticElement();
        GraphicalEditPart startPart = null;
        HashMap<GraphicalEditPart, Node> partNodeMap = new HashMap<GraphicalEditPart, Node>();
        HashSet<ConnectionEditPart> relationshipsToConsider = new HashSet<ConnectionEditPart>();
        for (Object o : this.selectedElement.getChildren()) {
            GraphicalEditPart gep = (GraphicalEditPart)o;
            if (!(gep instanceof StateEditPart)) continue;
            partNodeMap.put(gep, (Node)gep.getNotationView());
            if (gep.resolveSemanticElement().equals(mio.getStart())) {
                startPart = gep;
            }
            for (Object con : gep.getSourceConnections()) {
                ConnectionEditPart cep = (ConnectionEditPart)con;
                if (!(cep instanceof TransitionEditPart)) continue;
                relationshipsToConsider.add(cep);
            }
        }
        if (startPart == null) {
            startPart = (GraphicalEditPart)this.selectedElement.getChildren().get(0);
        }
        MioDefaultLayout layout = new MioDefaultLayout(startPart, partNodeMap, relationshipsToConsider);
        layout.run();
        return CommandResult.newOKCommandResult();
    }
}

