/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views.commands;

import java.io.File;
import net.miowb.common.FileSaveDialog;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.diagram.edit.parts.ModalIOAutomatonEditPart;
import net.miowb.views.Mio2Dot;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.ui.PlatformUI;

public class CreateDOTFileCommand
extends AbstractTransactionalCommand {
    private ModalIOAutomatonEditPart selectedElement;

    public CreateDOTFileCommand(ModalIOAutomatonEditPart selectedElement) {
        super(TransactionUtil.getEditingDomain((EObject)selectedElement.resolveSemanticElement()), "Strongly Minimize", null);
        this.selectedElement = selectedElement;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ModalIOAutomaton mio = (ModalIOAutomaton)this.selectedElement.resolveSemanticElement();
        FileSaveDialog d = new FileSaveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Saving", "Save it");
        d.open();
        int returncode = d.getReturnCode();
        if (returncode == 0) {
            try {
                File file = new File(d.getFirstResult().getLocation().toOSString());
                Mio2Dot.writeDot(file, mio);
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return CommandResult.newCancelledCommandResult();
            }
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newCancelledCommandResult();
    }
}

