/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.views;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.model.miocontract.ModalIOContract;

public class Mio2Dot {
    public static void writeDot(File file, ModalIOAutomaton mio) throws IOException {
        FileWriter outFile = new FileWriter(file);
        PrintWriter out = new PrintWriter(outFile);
        Mio2Dot.writeMIO(out, mio, "G");
        out.close();
    }

    private static void writeMIO(PrintWriter out, ModalIOAutomaton mio, String name) {
        out.println("digraph " + name + " {");
        out.println("rankdir=LR;");
        for (State s : mio.getStates()) {
            out.println(String.valueOf(mio.getStates().indexOf((Object)s)) + " [shape=circle,margin=0,label=\"" + s.getLabel() + "\"];");
        }
        out.println("init [shape=point];");
        out.println("init -> " + mio.getStates().indexOf((Object)mio.getStart()));
        for (Transition t : mio.getTransitions()) {
            out.print(String.valueOf(mio.getStates().indexOf((Object)t.getFrom())) + " -> " + mio.getStates().indexOf((Object)t.getTo()) + " [label=\"" + t.getAction().toNiceString() + "\"");
            if (t.isMay()) {
                out.println(",style=dashed];");
                continue;
            }
            out.println("];");
        }
        out.println("}");
    }

    public static void writeDot(File file, ModalIOContract mio) throws IOException {
        FileWriter outFile = new FileWriter(file);
        PrintWriter out = new PrintWriter(outFile);
        Mio2Dot.writeMIO(out, (ModalIOAutomaton)mio.getEnvironments().get(0), "Assume");
        Mio2Dot.writeMIO(out, (ModalIOAutomaton)mio.getSpecifications().get(0), "Guarantee");
        out.close();
    }
}

