/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.model.mio.diagram.part;

import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.diagram.edit.view.DiagramNodeWrapper;
import net.miowb.model.mio.diagram.part.ModalioDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class ModalioVisualIDRegistry {
    private static final String DEBUG_KEY = "net.miowb.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Modalio".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        if (view instanceof DiagramNodeWrapper) {
            if ("Modalio".equals(view.getType())) {
                return 1111;
            }
            return -1;
        }
        return ModalioVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                ModalioDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (MioPackage.eINSTANCE.getModalIOAutomaton().isSuperTypeOf(domainElement.eClass()) && ModalioVisualIDRegistry.isDiagram((ModalIOAutomaton)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = ModalioVisualIDRegistry.getModelID(containerView);
        if (!"Modalio".equals(containerModelID)) {
            return -1;
        }
        if ("Modalio".equals(containerModelID)) {
            containerVisualID = ModalioVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: 
            case 1111: {
                if (!MioPackage.eINSTANCE.getState().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = ModalioVisualIDRegistry.getModelID(containerView);
        if (!"Modalio".equals(containerModelID)) {
            return false;
        }
        if ("Modalio".equals(containerModelID)) {
            containerVisualID = ModalioVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (MioPackage.eINSTANCE.getTransition().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        return -1;
    }

    private static boolean isDiagram(ModalIOAutomaton element) {
        return true;
    }
}

