/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.model.mio.diagram.edit.parts;

import net.miowb.model.mio.Action;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.Transition;
import net.miowb.model.mio.diagram.edit.parts.WrappingLabelEditPart;
import net.miowb.model.mio.diagram.edit.policies.TransitionItemSemanticEditPolicy;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class TransitionEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    private static final Color outputTransitionColor = new Color(null, 127, 0, 0);
    private static final Color inputTransitionColor = new Color(null, 0, 127, 0);
    private static final Color internalTransitionColor = new Color(null, 128, 128, 128);
    private static final Color communicationTransitionColor = new Color(null, 0, 0, 127);
    public static final int VISUAL_ID = 4001;
    private boolean isMarkedProblematic;
    private boolean isMarked;

    public boolean isMarkedProblematic() {
        return this.isMarkedProblematic;
    }

    public void setMarkedProblematic(boolean isMarkedProblematic) {
        this.isMarkedProblematic = isMarkedProblematic;
        this.refreshForegroundColor();
    }

    public boolean isMarked() {
        return this.isMarked;
    }

    public void setMarked(boolean isMarked) {
        this.isMarked = isMarked;
        this.refreshForegroundColor();
    }

    public TransitionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new TransitionItemSemanticEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof WrappingLabelEditPart) {
            ((WrappingLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureMayTransitionFigureLabel());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, index);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return childEditPart instanceof WrappingLabelEditPart;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Connection createConnectionFigure() {
        TransitionFigure figure = new TransitionFigure();
        this.handleElementChange(figure);
        return figure;
    }

    public TransitionFigure getPrimaryShape() {
        return (TransitionFigure)this.getFigure();
    }

    protected void handleNotificationEvent(Notification notification) {
        if (MioPackage.eINSTANCE.getTransition_Action().equals(notification.getFeature())) {
            this.refreshForegroundColor();
        } else if (notification.getFeature() == NotationPackage.Literals.VIEW__ELEMENT && (EObject)notification.getNotifier() == this.getNotationView()) {
            this.handleElementChange(this.getPrimaryShape());
        }
        super.handleNotificationEvent(notification);
    }

    protected void refreshForegroundColor() {
        EObject semanticElement = this.resolveSemanticElement();
        if (!(semanticElement instanceof Transition)) {
            return;
        }
        Transition transition = (Transition)semanticElement;
        Action action = transition.getAction();
        if (this.isMarked()) {
            this.setForegroundColor(ColorConstants.blue);
        } else if (this.isMarkedProblematic()) {
            this.setForegroundColor(ColorConstants.red);
        } else if (action == null) {
            this.setForegroundColor(null);
        } else if (action.isInternal()) {
            this.setForegroundColor(internalTransitionColor);
        } else if (action.isInput()) {
            this.setForegroundColor(inputTransitionColor);
        } else if (action.isOutput()) {
            this.setForegroundColor(outputTransitionColor);
        } else if (action.isCommunication()) {
            this.setForegroundColor(communicationTransitionColor);
        }
    }

    protected void handleElementChange(TransitionFigure figure) {
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof MustTransition) {
            figure.setLineStyle(1);
            figure.setLineWidth(2);
        } else {
            figure.setLineStyle(2);
            figure.setLineWidth(2);
        }
    }

    public class TransitionFigure
    extends PolylineConnectionEx {
        private WrappingLabel fFigureMayTransitionFigureLabel;

        public TransitionFigure() {
            this.setLineStyle(2);
            this.setLineWidth(2);
            this.createContents();
            this.setTargetDecoration(this.createTargetDecoration());
        }

        private void createContents() {
            this.fFigureMayTransitionFigureLabel = new WrappingLabel();
            this.fFigureMayTransitionFigureLabel.setText("ActionDef");
            this.add((IFigure)this.fFigureMayTransitionFigureLabel);
        }

        private RotatableDecoration createTargetDecoration() {
            PolylineDecoration df = new PolylineDecoration();
            df.setLineWidth(2);
            df.setScale(8.0, 6.0);
            return df;
        }

        public WrappingLabel getFigureMayTransitionFigureLabel() {
            return this.fFigureMayTransitionFigureLabel;
        }
    }
}

