/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.model.mio.diagram.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.miowb.diagram.contributions.CircleLayout;
import net.miowb.diagram.contributions.CircleNodeFigure;
import net.miowb.diagram.contributions.MioConnectionHandleEditPolicy;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.model.mio.diagram.edit.parts.StateLabelEditPart;
import net.miowb.model.mio.diagram.edit.policies.StateItemSemanticEditPolicy;
import net.miowb.model.mio.diagram.part.ModalioVisualIDRegistry;
import net.miowb.model.mio.diagram.providers.ModalioElementTypes;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class StateEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 2001;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private boolean isMarkedProblematic;

    public StateEditPart(View view) {
        super(view);
    }

    public boolean isMarkedProblematic() {
        return this.isMarkedProblematic;
    }

    public void setMarkedProblematic(boolean isMarkedProblematic) {
        this.isMarkedProblematic = isMarkedProblematic;
        this.refreshBackgroundColor();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new StateItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new MioConnectionHandleEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new StateFigure();
        return this.primaryShape;
    }

    public StateFigure getPrimaryShape() {
        return (StateFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof StateLabelEditPart) {
            ((StateLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureStateFigureLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return childEditPart instanceof StateLabelEditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        CircleNodeFigure result = new CircleNodeFigure(50, 50);
        return result;
    }

    protected void refreshBounds() {
        int width = 10;
        int height = 10;
        Dimension size = new Dimension(width, height);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy result = super.getPrimaryDragEditPolicy();
        if (result instanceof ResizableEditPolicy) {
            ResizableEditPolicy ep = (ResizableEditPolicy)result;
            ep.setResizeDirections(0);
        }
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        this.updateFixedSize(this.getPrimaryShape());
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(ModalioVisualIDRegistry.getType(5001));
    }

    public List<IElementType> getMARelTypesOnSource() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(ModalioElementTypes.MayTransition_4001);
        return types;
    }

    public List<IElementType> getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (targetEditPart instanceof StateEditPart) {
            types.add(ModalioElementTypes.MayTransition_4001);
        }
        return types;
    }

    public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == ModalioElementTypes.MayTransition_4001) {
            types.add(ModalioElementTypes.State_2001);
        }
        return types;
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(ModalioElementTypes.MayTransition_4001);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == ModalioElementTypes.MayTransition_4001) {
            types.add(ModalioElementTypes.State_2001);
        }
        return types;
    }

    protected void addSemanticListeners() {
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof State) {
            ModalIOAutomaton mio = ((State)this.resolveSemanticElement()).getAutomaton();
            this.addListenerFilter("StartState", (NotificationListener)this, (EObject)mio);
        }
        this.addListenerFilter("StateFixedSize", (NotificationListener)this, (EObject)this.getDiagramView().getStyle(NotationPackage.Literals.BOOLEAN_VALUE_STYLE), (EStructuralFeature)NotationPackage.Literals.BOOLEAN_VALUE_STYLE__BOOLEAN_VALUE);
        super.addSemanticListeners();
    }

    protected void removeSemanticListeners() {
        this.removeListenerFilter("StateFixedSize");
        this.removeListenerFilter("StartState");
        super.removeSemanticListeners();
    }

    protected void handleNotificationEvent(Notification notification) {
        if (MioPackage.eINSTANCE.getModalIOAutomaton_Start().equals(notification.getFeature())) {
            this.refreshBackgroundColor();
            this.refreshForegroundColor();
        } else if (NotationPackage.Literals.BOOLEAN_VALUE_STYLE__BOOLEAN_VALUE.equals(notification.getFeature())) {
            this.updateFixedSize(this.getPrimaryShape());
            this.getPrimaryShape().revalidate();
        }
        super.handleNotificationEvent(notification);
    }

    protected void refreshForegroundColor() {
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof State && ((State)semanticElement).getAutomaton().getStart() != null && ((State)semanticElement).getAutomaton().getStart().equals(semanticElement)) {
            LineStyle style = (LineStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.LINE_STYLE);
            if (style != null) {
                this.setForegroundColor(ColorConstants.black);
            }
        } else {
            LineStyle style = (LineStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.LINE_STYLE);
            if (style != null) {
                this.setForegroundColor(ColorConstants.gray);
            }
        }
    }

    protected void refreshBackgroundColor() {
        EObject semanticElement = this.resolveSemanticElement();
        if (!(semanticElement instanceof State)) {
            return;
        }
        State state = (State)semanticElement;
        ModalIOAutomaton mio = state.getAutomaton();
        this.setLineWidth(2);
        this.setBackgroundColor(null);
        if (this.isMarkedProblematic()) {
            this.setBackgroundColor(ColorConstants.red);
        } else if (mio.getStart() != null && mio.getStart().equals(state)) {
            this.setLineWidth(4);
        }
    }

    protected void updateFixedSize(StateFigure figure) {
        Diagram diagram = this.getDiagramView();
        boolean fixedSize = false;
        BooleanValueStyle bvs = (BooleanValueStyle)diagram.getStyle(NotationPackage.Literals.BOOLEAN_VALUE_STYLE);
        if (bvs != null) {
            fixedSize = bvs.isBooleanValue();
        }
        ((CircleLayout)figure.getLayoutManager()).setFixedSize(fixedSize);
    }

    public class StateFigure
    extends Ellipse {
        private WrappingLabel fFigureStateFigureLabel;

        public StateFigure() {
            CircleLayout layoutThis = new CircleLayout();
            layoutThis.numColumns = 1;
            layoutThis.makeColumnsEqualWidth = true;
            layoutThis.horizontalSpacing = 0;
            layoutThis.verticalSpacing = 0;
            layoutThis.marginWidth = 0;
            layoutThis.marginHeight = 0;
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setForegroundColor(ColorConstants.blue);
            this.setBorder((Border)new MarginBorder(5, 5, 5, 5));
            this.setLineWidth(2);
            this.setFill(true);
            this.setPreferredSize(new Dimension(StateEditPart.this.getMapMode().DPtoLP(50), StateEditPart.this.getMapMode().DPtoLP(50)));
            this.createContents();
        }

        private void createContents() {
            this.fFigureStateFigureLabel = new WrappingLabel();
            this.fFigureStateFigureLabel.setText("");
            GridData constraintFFigureStateFigureLabel = new GridData();
            constraintFFigureStateFigureLabel.verticalAlignment = 2;
            constraintFFigureStateFigureLabel.horizontalAlignment = 2;
            constraintFFigureStateFigureLabel.horizontalIndent = 0;
            constraintFFigureStateFigureLabel.horizontalSpan = 1;
            constraintFFigureStateFigureLabel.verticalSpan = 1;
            constraintFFigureStateFigureLabel.grabExcessHorizontalSpace = true;
            constraintFFigureStateFigureLabel.grabExcessVerticalSpace = true;
            this.add((IFigure)this.fFigureStateFigureLabel, constraintFFigureStateFigureLabel);
        }

        public WrappingLabel getFigureStateFigureLabel() {
            return this.fFigureStateFigureLabel;
        }
    }
}

