/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.model.mio.diagram.edit.commands;

import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.model.mio.diagram.edit.policies.ModalioBaseItemSemanticEditPolicy;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class TransitionReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public TransitionReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof MayTransition)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof State) || !(this.newEnd instanceof State)) {
            return false;
        }
        State target = this.getLink().getTo();
        if (!(this.getLink().eContainer() instanceof ModalIOAutomaton)) {
            return false;
        }
        ModalIOAutomaton container = (ModalIOAutomaton)this.getLink().eContainer();
        return ModalioBaseItemSemanticEditPolicy.getLinkConstraints().canExistMayTransition_4001(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof State) || !(this.newEnd instanceof State)) {
            return false;
        }
        State source = this.getLink().getFrom();
        if (!(this.getLink().eContainer() instanceof ModalIOAutomaton)) {
            return false;
        }
        ModalIOAutomaton container = (ModalIOAutomaton)this.getLink().eContainer();
        return ModalioBaseItemSemanticEditPolicy.getLinkConstraints().canExistMayTransition_4001(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setFrom(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTo(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected MayTransition getLink() {
        return (MayTransition)this.getElementToEdit();
    }

    protected State getOldSource() {
        return (State)this.oldEnd;
    }

    protected State getNewSource() {
        return (State)this.newEnd;
    }

    protected State getOldTarget() {
        return (State)this.oldEnd;
    }

    protected State getNewTarget() {
        return (State)this.newEnd;
    }
}

