/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.diagram.contributions.commands;

import java.util.List;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.Transition;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteActionsCommand
extends AbstractTransactionalCommand {
    private final List<Action> actionList;
    private final ModalIOAutomaton automaton;
    private boolean displayInUseMessages;

    public DeleteActionsCommand(List<Action> actionList, ModalIOAutomaton automaton, boolean displayInUseMessages) {
        super(TransactionUtil.getEditingDomain((EObject)automaton), "Delete Actions", null);
        this.actionList = actionList;
        this.automaton = automaton;
        this.displayInUseMessages = displayInUseMessages;
    }

    public DeleteActionsCommand(List<Action> actionList, ModalIOAutomaton automaton) {
        this(actionList, automaton, true);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (Action a : this.actionList) {
            if (this.isActionNeeded(a)) {
                if (!this.displayInUseMessages) continue;
                String label = a.getLabel();
                if (label == null) {
                    label = "unnamed action";
                }
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Mio Workbench", (String)("Cannot delete action " + label + ": it is used in at least one transition."));
                continue;
            }
            this.automaton.removeAction(a);
        }
        return CommandResult.newOKCommandResult();
    }

    private boolean isActionNeeded(Action a) {
        List transitions = this.automaton.getTransitions();
        for (Transition transition : transitions) {
            if (!transition.getAction().equals(a)) continue;
            return true;
        }
        return false;
    }
}

