/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.diagram.contributions.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.CommunicationAction;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.Transition;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CollapseActionCommand
extends AbstractTransactionalCommand {
    private final ModalIOAutomaton mio;

    public CollapseActionCommand(ModalIOAutomaton m) {
        super(TransactionUtil.getEditingDomain((EObject)m), "Collapse actions", null);
        this.mio = m;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList<Action> to_be_removed = new ArrayList<Action>();
        for (Action a : this.mio.getActions()) {
            if (this.doesOccurOnTransition(this.mio, a) || !this.doesOccurOnTransition(this.mio, a.getLabel())) continue;
            to_be_removed.add(a);
        }
        for (Action a : to_be_removed) {
            if (a instanceof InputAction) {
                this.mio.getInputs().remove((Object)a);
                continue;
            }
            if (a instanceof OutputAction) {
                this.mio.getOutputs().remove((Object)a);
                continue;
            }
            if (a instanceof CommunicationAction) {
                this.mio.getCommunications().remove((Object)a);
                continue;
            }
            this.mio.getInternals().remove((Object)a);
        }
        ArrayList<Action> final_actions = new ArrayList<Action>();
        HashMap<Action, Action> old_to_new_map = new HashMap<Action, Action>();
        for (Action a : this.mio.getActions()) {
            Action b = this.getActionByLabel(final_actions, a.getLabel());
            if (b == null) {
                final_actions.add(a);
                continue;
            }
            if (a instanceof InputAction && b instanceof InputAction || a instanceof OutputAction && b instanceof OutputAction || a instanceof InternalAction && b instanceof InternalAction || a instanceof CommunicationAction && b instanceof CommunicationAction) {
                old_to_new_map.put(a, b);
                continue;
            }
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"MIO Workbench", (String)("Action " + a.getLabel() + " appears with at least two types (input, output, or internal)."));
            return CommandResult.newErrorCommandResult((String)("Action " + a.getLabel() + " appears with at least two types (input, output, or internal)."));
        }
        for (Transition t : this.mio.getTransitions()) {
            if (final_actions.contains(t.getAction())) continue;
            Action new_action = (Action)old_to_new_map.get(t.getAction());
            t.setAction(new_action);
        }
        for (Action a : old_to_new_map.keySet()) {
            if (a instanceof InputAction) {
                this.mio.getInputs().remove((Object)a);
                continue;
            }
            if (a instanceof OutputAction) {
                this.mio.getOutputs().remove((Object)a);
                continue;
            }
            if (a instanceof CommunicationAction) {
                this.mio.getCommunications().remove((Object)a);
                continue;
            }
            this.mio.getInternals().remove((Object)a);
        }
        return CommandResult.newOKCommandResult();
    }

    private boolean doesOccurOnTransition(ModalIOAutomaton mio, Action a) {
        for (Transition t : mio.getTransitions()) {
            if (!t.getAction().equals(a)) continue;
            return true;
        }
        return false;
    }

    private boolean doesOccurOnTransition(ModalIOAutomaton mio, String label) {
        for (Transition t : mio.getTransitions()) {
            if (!t.getAction().getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    private Action getActionByLabel(List<Action> list, String label) {
        for (Action a : list) {
            if (!a.getLabel().equals(label)) continue;
            return a;
        }
        return null;
    }
}

