/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.diagram.contributions.commands;

import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.Transition;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class ChangeTransitionTypeCommand
extends AbstractTransactionalCommand {
    private final IGraphicalEditPart selectedElement;
    private final EClass newType;

    public ChangeTransitionTypeCommand(IGraphicalEditPart selectedElement, EClass newType) {
        super(TransactionUtil.getEditingDomain((EObject)selectedElement.resolveSemanticElement()), "Switch transition type", null);
        this.selectedElement = selectedElement;
        this.newType = newType;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Transition oldTransition = (Transition)this.selectedElement.resolveSemanticElement();
        if (oldTransition.eClass().equals(this.newType)) {
            return CommandResult.newOKCommandResult();
        }
        Transition newTransition = (Transition)MioFactory.eINSTANCE.create(this.newType);
        newTransition.setAction(oldTransition.getAction());
        newTransition.setFrom(oldTransition.getFrom());
        newTransition.setTo(oldTransition.getTo());
        ModalIOAutomaton automaton = oldTransition.getAutomaton();
        if (this.newType.equals(MioPackage.Literals.MUST_TRANSITION)) {
            automaton.getMustTransitions().add((Object)((MustTransition)newTransition));
            automaton.getMayTransitions().remove((Object)((MayTransition)oldTransition));
        } else {
            automaton.getMustTransitions().remove((Object)((MustTransition)oldTransition));
            automaton.getMayTransitions().add((Object)((MayTransition)newTransition));
        }
        View elementView = this.selectedElement.getPrimaryView();
        elementView.setElement((EObject)newTransition);
        return CommandResult.newOKCommandResult();
    }
}

