/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.diagram.contributions.commands;

import net.miowb.model.mio.Action;
import net.miowb.model.mio.CommunicationAction;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.Transition;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class ChangeTransitionActionTypeCommand
extends AbstractTransactionalCommand {
    private final Action oldAction;
    private final ModalIOAutomaton automaton;
    private final EClass newType;
    private Action newAction;

    public ChangeTransitionActionTypeCommand(Action oldAction, ModalIOAutomaton automaton, EClass newType) {
        super(TransactionUtil.getEditingDomain((EObject)oldAction), "Switch transition action type", null);
        this.oldAction = oldAction;
        this.newType = newType;
        this.automaton = automaton;
        this.newAction = null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.oldAction.eClass().equals(this.newType)) {
            return CommandResult.newOKCommandResult();
        }
        this.newAction = (Action)MioFactory.eINSTANCE.create(this.newType);
        this.newAction.setLabel(this.oldAction.getLabel());
        if (this.newType.equals(MioPackage.Literals.OUTPUT_ACTION)) {
            this.automaton.getOutputs().add((Object)((OutputAction)this.newAction));
        } else if (this.newType.equals(MioPackage.Literals.INPUT_ACTION)) {
            this.automaton.getInputs().add((Object)((InputAction)this.newAction));
        } else if (this.newType.equals(MioPackage.Literals.COMMUNICATION_ACTION)) {
            this.automaton.getCommunications().add((Object)((CommunicationAction)this.newAction));
        } else {
            this.automaton.getInternals().add((Object)((InternalAction)this.newAction));
        }
        for (Transition t : this.automaton.getTransitions()) {
            if (t.getAction() == null || !t.getAction().equals(this.oldAction)) continue;
            t.setAction(this.newAction);
        }
        this.automaton.removeAction(this.oldAction);
        return CommandResult.newOKCommandResult();
    }

    public Action getNewAction() {
        return this.newAction;
    }
}

