/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.diagram.contributions;

import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class CircleNodeFigure
extends DefaultSizeNodeFigure {
    private ConnectionAnchor anchor;

    public CircleNodeFigure(int width, int height) {
        super(width, height);
    }

    public PointList getPolygonPoints() {
        Rectangle anchRect = this.getHandleBounds();
        Ellipse2D.Double el = new Ellipse2D.Double(anchRect.x, anchRect.y, anchRect.width, anchRect.height);
        PathIterator pit = el.getPathIterator(null);
        double[] coords = new double[6];
        PointList points = new PointList();
        int segment = pit.currentSegment(coords);
        while (segment != 4) {
            switch (segment) {
                case 3: {
                    points.addPoint((int)coords[0], (int)coords[1]);
                    points.addPoint((int)coords[2], (int)coords[3]);
                    points.addPoint((int)coords[4], (int)coords[5]);
                    break;
                }
                case 0: 
                case 1: {
                    points.addPoint((int)coords[0], (int)coords[1]);
                }
            }
            pit.next();
            segment = pit.currentSegment(coords);
        }
        return points;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        return this.getConnectionAnchor("center");
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        return this.getConnectionAnchor("center");
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        if (terminal.equals("center")) {
            if (this.anchor == null) {
                this.anchor = new EllipseAnchor((IFigure)this);
            }
            return this.anchor;
        }
        return null;
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        String selectedTerminal = null;
        if (this.anchor == c) {
            selectedTerminal = "center";
        }
        return selectedTerminal;
    }
}

