/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.model.miocontract.presentation;

import java.util.LinkedList;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.workbench.diagrams.DiagramManager;
import net.miowb.workbench.diagrams.IMioDiagrams;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ReplaceMioCommand
extends AbstractOverrideableCommand {
    private ModalIOAutomaton oldA;
    private ModalIOAutomaton newA;
    private LinkedList<EObject> oldContent;

    protected ReplaceMioCommand(EditingDomain domain, ModalIOAutomaton oldA, ModalIOAutomaton newA) {
        super(domain);
        this.oldA = oldA;
        this.newA = newA;
    }

    public void doExecute() {
        Resource r = this.oldA.eResource();
        this.oldContent = new LinkedList(r.getContents());
        r.getContents().clear();
        r.getContents().add((Object)this.newA);
        EObject diagram = ((IMioDiagrams)DiagramManager.getDiagrams().get(0)).getDiagram(this.newA);
        r.getContents().add((Object)diagram);
    }

    public void doUndo() {
        Resource r = this.newA.eResource();
        r.getContents().clear();
        r.getContents().addAll(this.oldContent);
    }

    public void doRedo() {
        this.doExecute();
    }

    protected boolean prepare() {
        boolean result = !this.domain.isReadOnly(this.oldA.eResource());
        return result;
    }
}

