/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.model.miocontract.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miowb.common.FileLoadDialog;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.provider.MioItemProviderAdapterFactory;
import net.miowb.model.miocontract.MiocontractPackage;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.model.miocontract.presentation.AutomatoncontractEditorPlugin;
import net.miowb.model.miocontract.presentation.DropHelper;
import net.miowb.model.miocontract.presentation.ForwardUndoCompoundCommand;
import net.miowb.model.miocontract.presentation.ReplaceMioCommand;
import net.miowb.model.miocontract.provider.MiocontractItemProviderAdapterFactory;
import net.miowb.operations.common.Helpers;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.IMioOperations;
import net.miowb.workbench.operations.OperationManager;
import net.miowb.workbench.operations.contracts.ContractHelpers;
import net.miowb.workbench.shell.MessageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class MiocontractEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected ListViewer envList;
    protected ListViewer specList;
    protected Text nameText;
    protected boolean isNameEditing;
    private ModifyListener nameTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            if (MiocontractEditor.this.isNameEditing) {
                return;
            }
            if (MiocontractEditor.this.contract.getName() == null || !MiocontractEditor.this.contract.getName().equals(MiocontractEditor.this.nameText.getText())) {
                MiocontractEditor.this.isNameEditing = true;
                Command sc = SetCommand.create((EditingDomain)MiocontractEditor.this.getEditingDomain(), (Object)MiocontractEditor.this.contract, (Object)MiocontractPackage.Literals.MODAL_IO_CONTRACT__NAME, (Object)MiocontractEditor.this.nameText.getText());
                MiocontractEditor.this.getEditingDomain().getCommandStack().execute(sc);
                MiocontractEditor.this.isNameEditing = false;
            }
        }
    };
    private Adapter changeAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (feature != null) {
                if (feature.equals(MiocontractPackage.Literals.MODAL_IO_CONTRACT__NAME)) {
                    if (!MiocontractEditor.this.isNameEditing) {
                        MiocontractEditor.this.refreshNameText();
                    }
                } else if (feature.equals(MiocontractPackage.Literals.MODAL_IO_CONTRACT__ENVIRONMENTS) || feature.equals(MiocontractPackage.Literals.MODAL_IO_CONTRACT__SPECIFICATIONS)) {
                    MiocontractEditor.this.refreshContent();
                }
            }
        }
    };
    protected ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            MiocontractEditor.this.setSelection(selectionChangedEvent.getSelection());
        }
    };
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected ModalIOContract contract;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == MiocontractEditor.this.contentOutlinePage) {
                    MiocontractEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MiocontractEditor.this);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == MiocontractEditor.this.propertySheetPage) {
                    MiocontractEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MiocontractEditor.this);
                    MiocontractEditor.this.handleActivate();
                }
            } else if (p == MiocontractEditor.this) {
                MiocontractEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = MiocontractEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            MiocontractEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            MiocontractEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!MiocontractEditor.this.updateProblemIndication) return;
                        MiocontractEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MiocontractEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).MiocontractEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                            if (delta.getKind() == 2) {
                                this.removedResources.add(resource);
                            } else if (!(this).MiocontractEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    MiocontractEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).MiocontractEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!MiocontractEditor.this.isDirty()) {
                                MiocontractEditor.this.getSite().getPage().closeEditor((IEditorPart)MiocontractEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    MiocontractEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).MiocontractEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (MiocontractEditor.this.getSite().getPage().getActiveEditor() == MiocontractEditor.this) {
                                MiocontractEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                AutomatoncontractEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };

    private void refreshNameText() {
        String name = this.contract.getName();
        this.nameText.setText(name == null ? "" : name);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                EObject e;
                block7: {
                    if (resource.isLoaded()) {
                        resource.unload();
                        try {
                            resource.load(Collections.EMPTY_MAP);
                        }
                        catch (IOException exception) {
                            if (this.resourceToDiagnosticMap.containsKey(resource)) break block7;
                            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                        }
                    }
                }
                if (!((e = (EObject)resource.getContents().get(0)) instanceof ModalIOContract)) continue;
                this.setContract((ModalIOContract)e);
            }
            this.refreshContent();
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "net.miowb.model.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    AutomatoncontractEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        AutomatoncontractEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)MiocontractEditor.getString("_UI_FileConflict_label"), (String)MiocontractEditor.getString("_WARN_FileConflict"));
    }

    public MiocontractEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MiocontractItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MioItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                MiocontractEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MiocontractEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            MiocontractEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).MiocontractEditor.this.propertySheetPage != null && !(this).MiocontractEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).MiocontractEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ArrayList envSel = new ArrayList();
                    ArrayList specSel = new ArrayList();
                    for (Object o : theSelection) {
                        if (MiocontractEditor.this.contract.getEnvironments().contains(o)) {
                            envSel.add(o);
                        }
                        if (!MiocontractEditor.this.contract.getSpecifications().contains(o)) continue;
                        specSel.add(o);
                    }
                    MiocontractEditor.this.envList.setSelection((ISelection)new StructuredSelection(envSel.toArray()));
                    MiocontractEditor.this.specList.setSelection((ISelection)new StructuredSelection(specSel.toArray()));
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        this.setContract((ModalIOContract)resource.getContents().get(0));
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "net.miowb.model.editor", 0, MiocontractEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "net.miowb.model.editor", 0, MiocontractEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Composite inner = new Composite(this.getContainer(), 0);
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(inner);
            GridLayoutFactory.swtDefaults().numColumns(2).margins(5, 5).spacing(10, 2).applyTo(inner);
            Composite nameArea = new Composite(inner, 0);
            GridData gridData = new GridData(4, 128, true, false);
            gridData.horizontalSpan = 2;
            nameArea.setLayoutData((Object)gridData);
            Label nameLabel = new Label(nameArea, 0);
            nameLabel.setText("Name:");
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment(0, 5);
            nameLabel.setLayoutData((Object)data);
            this.nameText = new Text(nameArea, 2048);
            this.nameText.setText("");
            data = new FormData();
            data.left = new FormAttachment((Control)nameLabel, 5);
            data.top = new FormAttachment(0, 5);
            data.right = new FormAttachment(100, 0);
            this.nameText.setLayoutData((Object)data);
            this.refreshNameText();
            this.nameText.addModifyListener(this.nameTextListener);
            nameArea.setLayout((Layout)new FormLayout());
            Group envs = new Group(inner, 0);
            envs.setText("Assumptions");
            Group specs = new Group(inner, 0);
            specs.setText("Guarantees");
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)envs);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)specs);
            GridLayoutFactory.swtDefaults().applyTo((Composite)envs);
            GridLayoutFactory.swtDefaults().applyTo((Composite)specs);
            int dndOperations = 7;
            Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
            this.envList = new ListViewer((Composite)envs, 2560);
            this.envList.setContentProvider((IContentProvider)new ContractFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.envList.setLabelProvider((IBaseLabelProvider)new ContractFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.envList.addSelectionChangedListener(this.selectionChangedListener);
            this.createContextMenuFor((StructuredViewer)this.envList);
            this.envList.getList().addMouseListener((MouseListener)new ContractListMouseListener(this.envList));
            this.envList.addDropSupport(dndOperations, transfers, (DropTargetListener)new ListViewerDropListener(MiocontractPackage.Literals.MODAL_IO_CONTRACT__ENVIRONMENTS));
            this.specList = new ListViewer((Composite)specs, 2560);
            this.specList.setContentProvider((IContentProvider)new ContractFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.specList.setLabelProvider((IBaseLabelProvider)new ContractFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.specList.addSelectionChangedListener(this.selectionChangedListener);
            this.createContextMenuFor((StructuredViewer)this.specList);
            this.specList.getList().addMouseListener((MouseListener)new ContractListMouseListener(this.specList));
            this.specList.addDropSupport(dndOperations, transfers, (DropTargetListener)new ListViewerDropListener(MiocontractPackage.Literals.MODAL_IO_CONTRACT__SPECIFICATIONS));
            GridDataFactory.fillDefaults().grab(true, true).applyTo(this.envList.getControl());
            GridDataFactory.fillDefaults().grab(true, true).applyTo(this.specList.getControl());
            Composite envButtons = new Composite((Composite)envs, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)envButtons);
            envButtons.setLayout((Layout)new RowLayout());
            Button addEnvButton = new Button(envButtons, 8);
            addEnvButton.setText("Add Assumption");
            addEnvButton.addSelectionListener((SelectionListener)new AddButtonListener(MiocontractPackage.Literals.MODAL_IO_CONTRACT__ENVIRONMENTS));
            Button removeEnvButton = new Button(envButtons, 8);
            removeEnvButton.setText("Remove Assumption");
            removeEnvButton.addSelectionListener((SelectionListener)new RemoveButtonListener(this.envList, MiocontractPackage.Literals.MODAL_IO_CONTRACT__ENVIRONMENTS));
            Composite specButtons = new Composite((Composite)specs, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)specButtons);
            specButtons.setLayout((Layout)new RowLayout());
            Button addSpecButton = new Button(specButtons, 8);
            addSpecButton.setText("Add Guarantee");
            addSpecButton.addSelectionListener((SelectionListener)new AddButtonListener(MiocontractPackage.Literals.MODAL_IO_CONTRACT__SPECIFICATIONS));
            Button removeSpecButton = new Button(specButtons, 8);
            removeSpecButton.setText("Remove Guarantee");
            removeSpecButton.addSelectionListener((SelectionListener)new RemoveButtonListener(this.specList, MiocontractPackage.Literals.MODAL_IO_CONTRACT__SPECIFICATIONS));
            Composite contractButtonArea = new Composite(inner, 0);
            GridData gData = new GridData(4, 128, true, false);
            gridData.horizontalSpan = 2;
            contractButtonArea.setLayoutData((Object)gData);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)contractButtonArea);
            contractButtonArea.setLayout((Layout)new RowLayout());
            Button validateContractButton = new Button(contractButtonArea, 8);
            validateContractButton.setText("Validate Contract");
            validateContractButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        try {
                            MessageManager.setSendToShell((boolean)false);
                            MiocontractEditor.this.validateContract();
                            MessageDialog.openInformation((Shell)MiocontractEditor.this.getShell(), (String)"Validation successful.", (String)"Validation completed without errors");
                        }
                        catch (MioException ex) {
                            MessageDialog.openError((Shell)MiocontractEditor.this.getShell(), (String)"Validation error.", (String)(String.valueOf(ex.getMessage()) + "\n" + MessageManager.getMessagesAsString()));
                            MessageManager.setSendToShell((boolean)true);
                        }
                    }
                    finally {
                        MessageManager.setSendToShell((boolean)true);
                    }
                }
            });
            this.addPage((Control)inner);
            this.refreshContent();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MiocontractEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    MiocontractEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MiocontractEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, MiocontractEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    MiocontractEditor.this.contentOutlineViewer = this.getTreeViewer();
                    MiocontractEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    MiocontractEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)MiocontractEditor.this.adapterFactory));
                    MiocontractEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)MiocontractEditor.this.adapterFactory));
                    MiocontractEditor.this.contentOutlineViewer.setInput((Object)MiocontractEditor.this.editingDomain.getResourceSet());
                    MiocontractEditor.this.createContextMenuFor((StructuredViewer)MiocontractEditor.this.contentOutlineViewer);
                    if (!MiocontractEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        MiocontractEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(MiocontractEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    MiocontractEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MiocontractEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MiocontractEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    MiocontractEditor.this.setSelectionToViewer(selection);
                    MiocontractEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MiocontractEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : MiocontractEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !MiocontractEditor.this.isPersisted(resource) || MiocontractEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            MiocontractEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        MiocontractEditor.this.resourceToDiagnosticMap.put(resource, MiocontractEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            AutomatoncontractEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            AutomatoncontractEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(MiocontractEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(MiocontractEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(MiocontractEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return AutomatoncontractEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return AutomatoncontractEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return false;
    }

    protected Shell getShell() {
        return this.getSite().getShell();
    }

    public void openDialogEditor(ModalIOAutomaton a) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)new URIEditorInput(a.eResource().getURI()), "net.miowb.model.mio.diagram.part.ModalioDiagramEditorID");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void addAutomaton(EReference reference, IFile file) {
        try {
            ModalIOAutomaton a = this.loadAutomaton(file);
            this.addAutomaton(reference, a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addAutomaton(EReference reference, ModalIOAutomaton a) {
        Command sc = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.contract, (Object)reference, (Object)a);
        this.getEditingDomain().getCommandStack().execute(sc);
        this.refreshContent();
    }

    private void removeAutomaton(EReference reference, ModalIOAutomaton a) {
        Command sc = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.contract, (Object)reference, (Object)a);
        this.getEditingDomain().getCommandStack().execute(sc);
        this.refreshContent();
    }

    private ModalIOAutomaton loadAutomaton(IFile file) throws Exception {
        URI resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception exception) {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        if (!(eObject instanceof ModalIOAutomaton)) {
            throw new Exception("Could not read from " + resourceURI + ". Object in Resource is not of type Automaton.");
        }
        return (ModalIOAutomaton)eObject;
    }

    private void refreshContent() {
        this.refreshNameText();
        this.envList.setInput((Object)this.contract.getEnvironments());
        this.specList.setInput((Object)this.contract.getSpecifications());
    }

    private void setContract(ModalIOContract c) {
        this.removeListeners();
        this.contract = c;
        this.addListeners();
    }

    private void removeListeners() {
        if (this.contract != null) {
            this.contract.eAdapters().remove((Object)this.changeAdapter);
        }
    }

    private void addListeners() {
        if (this.contract != null) {
            this.contract.eAdapters().add((Object)this.changeAdapter);
        }
    }

    private void normalizeContract() throws Exception {
        if (this.contract.getEnvironments().size() > 0 && this.contract.getSpecifications().size() > 0) {
            IMioOperations ops = OperationManager.getOperations();
            Iterator iterator = this.contract.getSpecifications().iterator();
            while (iterator.hasNext()) {
                ModalIOAutomaton spec;
                ModalIOAutomaton curSpec = spec = (ModalIOAutomaton)iterator.next();
                for (ModalIOAutomaton env : this.contract.getEnvironments()) {
                    ModalIOAutomaton r;
                    curSpec = r = ops.weaken(env, curSpec);
                }
                curSpec.setName(String.valueOf(spec.getName()) + "(normalized)");
                ReplaceMioCommand rmc = new ReplaceMioCommand(this.getEditingDomain(), spec, curSpec);
                ReplaceCommand rc = new ReplaceCommand(this.getEditingDomain(), (EObject)this.contract, (EStructuralFeature)MiocontractPackage.Literals.MODAL_IO_CONTRACT__SPECIFICATIONS, (Object)spec, (Object)curSpec);
                ForwardUndoCompoundCommand fcc = new ForwardUndoCompoundCommand("Normalize");
                fcc.append((Command)rmc);
                fcc.append((Command)rc);
                this.getEditingDomain().getCommandStack().execute((Command)fcc);
            }
        }
    }

    private void strengthenContract() throws Exception {
        if (this.contract.getEnvironments().size() > 0 && this.contract.getSpecifications().size() > 0) {
            IMioOperations ops = OperationManager.getOperations();
            Iterator iterator = this.contract.getSpecifications().iterator();
            while (iterator.hasNext()) {
                ModalIOAutomaton spec;
                ModalIOAutomaton curSpec = spec = (ModalIOAutomaton)iterator.next();
                for (ModalIOAutomaton env : this.contract.getEnvironments()) {
                    ModalIOAutomaton r;
                    curSpec = r = ops.weaken(env, curSpec);
                }
                Helpers.removeUniversalState((ModalIOAutomaton)curSpec);
                curSpec.setName(String.valueOf(spec.getName()) + "(strengthened)");
                ReplaceMioCommand rmc = new ReplaceMioCommand(this.getEditingDomain(), spec, curSpec);
                ReplaceCommand rc = new ReplaceCommand(this.getEditingDomain(), (EObject)this.contract, (EStructuralFeature)MiocontractPackage.Literals.MODAL_IO_CONTRACT__SPECIFICATIONS, (Object)spec, (Object)curSpec);
                ForwardUndoCompoundCommand fcc = new ForwardUndoCompoundCommand("Strengthen");
                fcc.append((Command)rmc);
                fcc.append((Command)rc);
                this.getEditingDomain().getCommandStack().execute((Command)fcc);
            }
        }
    }

    private void validateContract() throws MioException {
        ContractHelpers.getReducedContract((ModalIOContract)this.contract);
    }

    class AddButtonListener
    extends SelectionAdapter {
        EReference reference;
        private IFile fLastResult;

        public AddButtonListener(EReference reference) {
            this.reference = reference;
        }

        public void widgetSelected(SelectionEvent e) {
            FileLoadDialog fLoadDialog = new FileLoadDialog(MiocontractEditor.this.getContainer().getShell(), "MIO Selection", "Plase select a .mio file...");
            fLoadDialog.setAllowMultiple(false);
            fLoadDialog.setBlockOnOpen(true);
            if (this.fLastResult instanceof IFile) {
                fLoadDialog.setInitialSelection((Object)this.fLastResult);
            }
            if (fLoadDialog.open() == 0) {
                this.fLastResult = (IFile)fLoadDialog.getFirstResult();
                MiocontractEditor.this.addAutomaton(this.reference, this.fLastResult);
            }
        }
    }

    public class ContractFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ContractFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            return ((EList)object).toArray();
        }
    }

    public class ContractFactoryLabelProvider
    extends AdapterFactoryLabelProvider {
        public ContractFactoryLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getText(Object object) {
            ModalIOAutomaton a = (ModalIOAutomaton)object;
            String label = a.getName();
            if (label == null || label.length() == 0) {
                label = "Unnamed MIO";
            }
            if (a.eResource() != null) {
                label = String.valueOf(label) + " [" + a.eResource().getURI().lastSegment() + "]";
            }
            return label;
        }
    }

    class ContractListMouseListener
    implements MouseListener {
        ListViewer list;

        public ContractListMouseListener(ListViewer list) {
            this.list = list;
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            IStructuredSelection sel = (IStructuredSelection)this.list.getSelection();
            if (sel.isEmpty()) {
                return;
            }
            ModalIOAutomaton a = (ModalIOAutomaton)sel.getFirstElement();
            MiocontractEditor.this.openDialogEditor(a);
        }
    }

    class ListViewerDropListener
    implements DropTargetListener {
        EReference reference;

        public ListViewerDropListener(EReference reference) {
            this.reference = reference;
        }

        public void dropAccept(DropTargetEvent event) {
            DropHelper.changeDropOperationToCopy(event);
        }

        public void drop(DropTargetEvent event) {
            IFile file = DropHelper.getFileFromDrop(event);
            if (file == null) {
                event.detail = 0;
            } else {
                MiocontractEditor.this.addAutomaton(this.reference, file);
            }
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragEnter(DropTargetEvent event) {
            DropHelper.changeDropOperationToCopy(event);
        }
    }

    class RemoveButtonListener
    extends SelectionAdapter {
        ListViewer list;
        EReference reference;

        public RemoveButtonListener(ListViewer list, EReference reference) {
            this.list = list;
            this.reference = reference;
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection sel = (IStructuredSelection)this.list.getSelection();
            if (sel.isEmpty()) {
                return;
            }
            ModalIOAutomaton a = (ModalIOAutomaton)sel.getFirstElement();
            MiocontractEditor.this.removeAutomaton(this.reference, a);
        }
    }
}

